<?php
class Procedimentos {
    public $dti;
	public $dtf;
    public $cpf;
	public $cns;
    public $cpf2;
	public $cns2;
	public $primeiraCons;
	public $totalEncontrado;
	public $procedimentos = array();
	public $ok;
	public $sql1;
	public $sql2;
	
	private $con;
	private $procs;
	private $cbos;

    public function __construct($con, $cns, $cpf, $cns2, $cpf2, $dti, $dtf, $cbos, $procs) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->cns = $cns;
		$this->cpf = $cpf;
		$this->cns2 = $cns2;
		$this->cpf2 = $cpf2;
		$this->con = $con;
		$this->cbos = $cbos;
		$this->procs = $procs;
		
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}
		// --------------------------------------------------------------------
		$tproa = "";
		if (count($this->procs) > 0){
			$tproa = "ds_filtro_proced_avaliados LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tproa .= "'%|".$v."|%',";
			}
			$tproa = substr($tproa,0,-1);
			$tproa .= "])";
		}
		$tpros = "";
		if (count($this->procs) > 0){
			$tpros = "ds_filtro_proced_solicitados LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tpros .= "'%|".$v."|%',";
			}
			$tpros = substr($tpros,0,-1);
			$tpros .= "])";
		}
		$cc = "";
		if (strlen($tproa) > 0){
			$cc = $tproa;
			if (strlen($tpros) > 0){
				$cc = "(".$cc." OR ".$tpros.")";
			}
		} else {
			if (strlen($tpros) > 0){
				$cc = $tpros;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_tempo_dum,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_proced_avaliados,
					t5.ds_filtro_proced_solicitados,
					t5.tipo,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT 
									nu_cns,
									nu_cpf_cidadao,
									co_dim_tempo, 
									co_dim_tempo_dum,
									CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
										ELSE co_dim_cbo_1 END
										co_dim_cbo,
									CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
										ELSE co_dim_unidade_saude_1 END
										co_dim_unidade_saude,
									CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
										ELSE co_dim_equipe_1 END
										co_dim_equipe,
									CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
										ELSE co_dim_profissional_1 END
										co_dim_profissional,
									CASE WHEN ds_filtro_proced_avaliados = '||' THEN 'S'
										ELSE 'A' END
									tipo,
									ds_filtro_proced_avaliados,
									ds_filtro_proced_solicitados,
									co_fat_cidadao_pec
								FROM
									tb_fat_atendimento_individual
								WHERE
									(nu_cns = '".$this->cns."' OR nu_cpf_cidadao = '".$this->cpf."' OR nu_cns = '".$this->cns2."' OR nu_cpf_cidadao = '".$this->cpf2."') AND
									(co_dim_tempo >= ".$this->dti." AND co_dim_tempo <= ".$this->dtf.")
									".$cc."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos."
			ORDER BY co_dim_tempo
		";
		// --------------------------------------------------------------------
		$tproac = "";
		if (count($this->procs) > 0){
			$tproac = " AND ds_filtro_procedimento LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tproac .= "'%|".$v."|%',";
			}
			$tproac = substr($tproac,0,-1);
			$tproac .= "])";
		}
		$this->sql2 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_procedimento,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT
									nu_cns,
									nu_cpf_cidadao,
									co_dim_unidade_saude, 
									co_dim_equipe, 
									co_dim_profissional, 
									co_dim_cbo, 
									co_dim_tempo, 
									st_escuta_inicial, 
									ds_filtro_procedimento,
									co_fat_cidadao_pec
								FROM 
									tb_fat_proced_atend
								WHERE
									(nu_cns = '".$this->cns."' OR nu_cpf_cidadao = '".$this->cpf."' OR nu_cns = '".$this->cns2."' OR nu_cpf_cidadao = '".$this->cpf2."') AND
									(co_dim_tempo >= ".$this->dti." AND co_dim_tempo <= ".$this->dtf.")
									".$tproac."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos."
			ORDER BY co_dim_tempo
		";
	}
	
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function atend(){
		$rs = $this->con->query($this->sql1);
		$this->procedimentos = array();
		$conta_array = 0;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe;
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_proced_avaliados;
					$this->procedimentos[$conta_array]['solicitado'] = $rows->ds_filtro_proced_solicitados;
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_atendimento_individual";
					$this->procedimentos[$conta_array]['tipo'] = $rows->tipo;
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
	}
	
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function proced(){
		$rs = $this->con->query($this->sql2);
		$this->procedimentos = array();
		$conta_array = 0;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe;
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_procedimento;
					$this->procedimentos[$conta_array]['solicitado'] = "||";
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_proced_atend";
					$this->procedimentos[$conta_array]['tipo'] = "A";
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
	}
	
	
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function todos(){
		$this->procedimentos = array();
		$conta_array = 0;
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe;
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_proced_avaliados;
					$this->procedimentos[$conta_array]['solicitado'] = $rows->ds_filtro_proced_solicitados;
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_atendimento_individual";
					$this->procedimentos[$conta_array]['tipo'] = $rows->tipo;
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe;
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_procedimento;
					$this->procedimentos[$conta_array]['solicitado'] = "||";
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_proced_atend";
					$this->procedimentos[$conta_array]['tipo'] = "A";
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
    public function total() {
		$this->procedimentos = array();
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
			}
		}
    }
}

class ProcedimentosFAT {
    public $dti;
	public $dtf;
    public $cfat;
	public $primeiraCons;
	public $totalEncontrado;
	public $procedimentos = array();
	public $ok;
	public $sql1;
	public $sql2;
	
	private $con;
	private $procs;
	private $cbos;

    public function __construct($con, $cfat, $dti, $dtf, $cbos, $procs) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->con = $con;
		$this->cbos = $cbos;
		$this->procs = $procs;
		$this->cfat = $cfat;
		
		/*
		$busca_cfat = "";
		$pos = strpos($cfat,":");
		if ($pos === false) {
			$this->cfat = $cfat;
			$busca_cfat = "(co_fat_cidadao_pec = ".$cfat.")";
		} else {
			$car = explode(":",$cfat);
			$this->cfat = $car[0];
			$busca_cfat = "(";
			for($w=0;$w<count($car);$w++){
				$busca_cfat .= "co_fat_cidadao_pec = ".$car[$w]." OR ";
			}
			$busca_cfat = substr($busca_cfat,0,-4).")";
		}
		*/
		
		$selfat = "";
		$vfats = explode(":",$this->cfat);
		if (count($vfats) > 1){
			foreach ($vfats as $vlf) {
				if (strlen(trim($vlf)) > 0){
					if ($vlf > 0){
						$selfat .= "co_fat_cidadao_pec = ".$vlf." OR ";
					}
				}
			}
			if (strlen($selfat) > 25){
				$selfat = substr($selfat,0,-4);
			}
		} else {
			$selfat = "co_fat_cidadao_pec = ".$vfats[0];
		}
		
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}
		// --------------------------------------------------------------------
		$tproa = "";
		if (count($this->procs) > 0){
			$tproa = "ds_filtro_proced_avaliados LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tproa .= "'%|".$v."|%',";
			}
			$tproa = substr($tproa,0,-1);
			$tproa .= "])";
		}
		$tpros = "";
		if (count($this->procs) > 0){
			$tpros = "ds_filtro_proced_solicitados LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tpros .= "'%|".$v."|%',";
			}
			$tpros = substr($tpros,0,-1);
			$tpros .= "])";
		}
		$cc = "";
		if (strlen($tproa) > 0){
			$cc = $tproa;
			if (strlen($tpros) > 0){
				$cc = "(".$cc." OR ".$tpros.")";
			}
		} else {
			if (strlen($tpros) > 0){
				$cc = $tpros;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_tempo_dum,
					t5.co_dim_equipe,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_proced_avaliados,
					t5.ds_filtro_proced_solicitados,
					t5.tipo,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT 
									nu_cns,
									nu_cpf_cidadao,
									co_dim_tempo, 
									co_dim_tempo_dum,
									CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
										ELSE co_dim_cbo_1 END
										co_dim_cbo,
									CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
										ELSE co_dim_unidade_saude_1 END
										co_dim_unidade_saude,
									CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
										ELSE co_dim_equipe_1 END
										co_dim_equipe,
									CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
										ELSE co_dim_profissional_1 END
										co_dim_profissional,
									CASE WHEN ds_filtro_proced_avaliados = '||' THEN 'S'
										ELSE 'A' END
									tipo,
									ds_filtro_proced_avaliados,
									ds_filtro_proced_solicitados,
									co_fat_cidadao_pec
								FROM
									tb_fat_atendimento_individual
								WHERE
									(".$selfat.") AND
									(co_dim_tempo >= ".$this->dti." AND co_dim_tempo <= ".$this->dtf.")
									".$cc."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos."
			ORDER BY co_dim_tempo
		";
		// --------------------------------------------------------------------
		$tproac = "";
		if (count($this->procs) > 0){
			$tproac = " AND ds_filtro_procedimento LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tproac .= "'%|".$v."|%',";
			}
			$tproac = substr($tproac,0,-1);
			$tproac .= "])";
		}
		$this->sql2 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_equipe,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_procedimento,
					t5.nu_cbo,
					t5.no_cbo,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT
									nu_cns,
									nu_cpf_cidadao,
									co_dim_unidade_saude, 
									co_dim_equipe, 
									co_dim_profissional, 
									co_dim_cbo, 
									co_dim_tempo, 
									st_escuta_inicial, 
									ds_filtro_procedimento,
									co_fat_cidadao_pec
								FROM 
									tb_fat_proced_atend
								WHERE
									(".$selfat.") AND
									(co_dim_tempo >= ".$this->dti." AND co_dim_tempo <= ".$this->dtf.")
									".$tproac."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$tcbos."
			ORDER BY co_dim_tempo
		";
	}
	
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function atend(){
		$rs = $this->con->query($this->sql1);
		$this->procedimentos = array();
		$conta_array = 0;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['codimequipe'] = $rows->co_dim_equipe;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe; 
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_proced_avaliados;
					$this->procedimentos[$conta_array]['solicitado'] = $rows->ds_filtro_proced_solicitados;
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_atendimento_individual";
					$this->procedimentos[$conta_array]['tipo'] = $rows->tipo;
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
	}
	
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function proced(){
		$rs = $this->con->query($this->sql2);
		$this->procedimentos = array();
		$conta_array = 0;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['codimequipe'] = $rows->co_dim_equipe;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe;
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_procedimento;
					$this->procedimentos[$conta_array]['solicitado'] = "||";
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_proced_atend";
					$this->procedimentos[$conta_array]['tipo'] = "A";
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
	}
	
	
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function todos(){
		$this->procedimentos = array();
		$conta_array = 0;
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['codimequipe'] = $rows->co_dim_equipe;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe; 
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_proced_avaliados;
					$this->procedimentos[$conta_array]['solicitado'] = $rows->ds_filtro_proced_solicitados;
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_atendimento_individual";
					$this->procedimentos[$conta_array]['tipo'] = $rows->tipo;
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
					$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->procedimentos[$conta_array]['codimequipe'] = $rows->co_dim_equipe;
					$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
					$this->procedimentos[$conta_array]['equipe'] = $rows->no_equipe; 
					$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->procedimentos[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->procedimentos[$conta_array]['avaliado'] = $rows->ds_filtro_procedimento;
					$this->procedimentos[$conta_array]['solicitado'] = "||";
					$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
					$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->procedimentos[$conta_array]['tabela'] = "tb_fat_proced_atend";
					$this->procedimentos[$conta_array]['tipo'] = "A";
					$this->procedimentos[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
    public function total() {
		$this->procedimentos = array();
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
			}
		}
    }
}

// ###########################################################################################################################################################

class ProcedimentosSIG {
    public $dti;
	public $dtf;
	public $totalEncontrado;
	public $procedimentos = array();
	public $ok;
	public $sql1;
	public $sql2;
	
	private $con;
	private $procs;
	private $cbos;
	private $ines;
	private $cness;

    public function __construct($con, $dti, $dtf, $cbos, $procs, $ines, $cness) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->con = $con;
		$this->cbos = $cbos;
		$this->procs = $procs;
		$this->ines = $ines;
		$this->cness = $cness;

		$tcness = "";
		if (count($this->cness) > 0){
			$tcness = "nu_cnes LIKE ANY (array[";
			foreach ($this->cness as $v) {
				$tcness .= "'".$v."%',";
			}
			$tcness = substr($tcness,0,-1);
			$tcness .= "])";
		}
		// --------------------------------------------------------------------
		$tines = "";
		if (count($this->ines) > 0){
			$tines = "nu_ine LIKE ANY (array[";
			foreach ($this->ines as $v) {
				$tines .= "'".$v."%',";
			}
			$tines = substr($tines,0,-1);
			$tines .= "])";
		}
		// --------------------------------------------------------------------
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}
		// --------------------------------------------------------------------
		$ccf = "";
		if (strlen($tcness) > 0 || strlen($tines) > 0 || strlen($tcbos) > 0){
			$ccf = "WHERE ";
			if (strlen($tcness) > 0){
				$ccf .= $tcness;
				if (strlen($tines) > 0){
					$ccf .= " AND ".$tines;
				}
				if (strlen($tcbos) > 0){
					$ccf .= " AND ".$tcbos;
				}
			} else {
				if (strlen($tines) > 0){
					$ccf .= $tines;
					if (strlen($tcbos) > 0){
						$ccf .= " AND ".$tcbos;
					}
				} else {
					$ccf .= $tcbos;
				}
			}
		}
	// --------------------------------------------------------------------
	// --------------------------------------------------------------------
		$tproa = "";
		if (count($this->procs) > 0){
			$tproa = "ds_filtro_proced_avaliados LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tproa .= "'%|".$v."|%',";
			}
			$tproa = substr($tproa,0,-1);
			$tproa .= "])";
		}
		$tpros = "";
		if (count($this->procs) > 0){
			$tpros = "ds_filtro_proced_solicitados LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tpros .= "'%|".$v."|%',";
			}
			$tpros = substr($tpros,0,-1);
			$tpros .= "])";
		}
		$cc = "";
		if (strlen($tproa) > 0){
			$cc = $tproa;
			if (strlen($tpros) > 0){
				$cc = "(".$cc." OR ".$tpros.")";
			}
		} else {
			if (strlen($tpros) > 0){
				$cc = $tpros;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.co_dim_tempo_dum,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_proced_avaliados,
					t5.ds_filtro_proced_solicitados,
					t5.tipo,
					t5.nu_cbo,
					t5.no_cbo,
					t5.dt_nascimento,
					t5.ds_filtro_cids,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT 
									nu_cns,
									nu_cpf_cidadao,
									co_dim_tempo, 
									co_dim_tempo_dum,
									CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2
										ELSE co_dim_cbo_1 END
										co_dim_cbo,
									CASE WHEN co_dim_unidade_saude_1 = 1 THEN co_dim_unidade_saude_2
										ELSE co_dim_unidade_saude_1 END
										co_dim_unidade_saude,
									CASE WHEN co_dim_equipe_1 = 1 THEN co_dim_equipe_2
										ELSE co_dim_equipe_1 END
										co_dim_equipe,
									CASE WHEN co_dim_profissional_1 = 1 THEN co_dim_profissional_2
										ELSE co_dim_profissional_1 END
										co_dim_profissional,
									CASE WHEN ds_filtro_proced_avaliados = '||' THEN 'S'
										ELSE 'A' END
									tipo,
									ds_filtro_proced_avaliados,
									ds_filtro_proced_solicitados,
									dt_nascimento,
									ds_filtro_cids,
									co_fat_cidadao_pec
								FROM
									tb_fat_atendimento_individual
								WHERE
									(ds_filtro_proced_avaliados <> '||' OR ds_filtro_proced_solicitados <> '||') AND
									(co_dim_tempo >= ".$this->dti." AND co_dim_tempo <= ".$this->dtf.")
									".$cc."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$ccf."
			ORDER BY co_dim_tempo
		";
		// --------------------------------------------------------------------
		$tproac = "";
		if (count($this->procs) > 0){
			$tproac = " AND ds_filtro_procedimento LIKE ANY (array[";
			foreach ($this->procs as $v) {
				$tproac .= "'%|".$v."|%',";
			}
			$tproac = substr($tproac,0,-1);
			$tproac .= "])";
		}
		$this->sql2 = "
			SELECT
				*
			FROM
			(
				SELECT
					t5.nu_cns,
					t5.nu_cpf_cidadao,
					t5.co_dim_tempo,
					t5.nu_ine,
					t5.no_equipe,
					t5.nu_cnes,
					t5.no_unidade_saude,
					t5.ds_filtro_procedimento,
					t5.nu_cbo,
					t5.no_cbo,
					t5.dt_nascimento,
					t5.co_fat_cidadao_pec,
					tb_dim_profissional.nu_cns AS cns_prof,
					tb_dim_profissional.no_profissional
				FROM
				(
					SELECT
						t3.*,
						tb_dim_cbo.nu_cbo,
						tb_dim_cbo.no_cbo
					FROM
					(
						SELECT
							t2.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t1.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT
									nu_cns,
									nu_cpf_cidadao,
									co_dim_unidade_saude, 
									co_dim_equipe, 
									co_dim_profissional, 
									co_dim_cbo, 
									co_dim_tempo, 
									st_escuta_inicial, 
									ds_filtro_procedimento,
									dt_nascimento,
									co_fat_cidadao_pec
								FROM 
									tb_fat_proced_atend
								WHERE
									(co_dim_tempo >= ".$this->dti." AND co_dim_tempo <= ".$this->dtf.")
									".$tproac."
							) AS t1
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t1.co_dim_equipe
						) AS t2
						LEFT JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t2.co_dim_unidade_saude
					) AS t3
					LEFT JOIN
						tb_dim_cbo
					ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
				) AS t5
				LEFT JOIN
					tb_dim_profissional
				ON tb_dim_profissional.co_seq_dim_profissional = t5.co_dim_profissional
			) AS t4
			".$ccf."
			ORDER BY co_dim_tempo
		";
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function todos(){
		$this->procedimentos = array();
		$conta_array = 0;
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$proc_cids = str_replace(" ","",substr(substr($rows->ds_filtro_cids,0,-1),1));
					$proc_solicitado = str_replace(" ","",substr(substr($rows->ds_filtro_proced_avaliados,0,-1),1));
					$proc_avaliado = str_replace(" ","",substr(substr($rows->ds_filtro_proced_solicitados,0,-1),1));
					$array_procs_av = explode("|",$proc_avaliado);
					$array_procs_so = explode("|",$proc_solicitado);
					$array_procs_total = array_unique(array_merge($array_procs_av, $array_procs_so));
					foreach ($array_procs_total as $arv) {
						if (strlen($arv) > 0){
							$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
							$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
							$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
							$this->procedimentos[$conta_array]['dtNascimento'] = $rows->dt_nascimento;
							$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
							$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
							$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
							$this->procedimentos[$conta_array]['procedimento'] = $arv;
							$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
							$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
							$this->procedimentos[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
							$this->procedimentos[$conta_array]['tabela'] = "tb_fat_atendimento_individual";
							$this->procedimentos[$conta_array]['cids'] = $proc_cids;
							$this->procedimentos[$conta_array]['sig'] = 0;
							if (strlen($arv) == 10){
								$this->procedimentos[$conta_array]['sig'] = 1;
							}
							$conta_array++;
						}
					}
				}
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$proc_realizado = str_replace(" ","",substr(substr($rows->ds_filtro_procedimento,0,-1),1));
					$array_procs_realizados = explode("|",$proc_realizado);
					$array_procs_total = array_unique($array_procs_realizados);
					foreach ($array_procs_total as $arv) {
						if (strlen($arv) > 0){
							$this->procedimentos[$conta_array]['cns'] = $rows->nu_cns;
							$this->procedimentos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
							$this->procedimentos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
							$this->procedimentos[$conta_array]['dtNascimento'] = $rows->dt_nascimento;
							$this->procedimentos[$conta_array]['ine'] = $rows->nu_ine;
							$this->procedimentos[$conta_array]['cnes'] = $rows->nu_cnes;
							$this->procedimentos[$conta_array]['cbo'] = $rows->nu_cbo;
							$this->procedimentos[$conta_array]['procedimento'] = $arv;
							$this->procedimentos[$conta_array]['cnsProfissional'] = $rows->cns_prof;
							$this->procedimentos[$conta_array]['nomeProfissional'] = $rows->no_profissional;
							$this->procedimentos[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
							$this->procedimentos[$conta_array]['tabela'] = "tb_fat_proced_atend";
							$this->procedimentos[$conta_array]['cids'] = "";
							$this->procedimentos[$conta_array]['sig'] = 0;
							if (strlen($arv) == 10){
								$this->procedimentos[$conta_array]['sig'] = 1;
							}
							$conta_array++;
						}
					}
				}
			}
		}
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
}





?>



