<?php
class Vacinas {
    public $dti;
	public $dtf;
	public $cfat;
	public $totalEncontrado;
	public $vacinas = array();
	public $ok;
	public $sql1;
	public $sql2;
	
	private $con;
	private $imunos;
	private $cbos;

    public function __construct($con, $cfat, $cbos, $imunos, $dti = 0, $dtf = 0) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->cfat = $cfat;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->con = $con;
		$this->cbos = $cbos;
		$this->imunos = $imunos;
		
		/*
		$busca_cfat = "";
		$pos = strpos($cfat,":");
		if ($pos === false) {
			$this->cfat = $cfat;
			$busca_cfat = "(co_cidadao = ".$cfat.")";
		} else {
			$car = explode(":",$cfat);
			$this->cfat = $car[0];
			$busca_cfat = "(";
			for($w=0;$w<count($car);$w++){
				$busca_cfat .= "co_cidadao = ".$car[$w]." OR ";
			}
			$busca_cfat = substr($busca_cfat,0,-4).")";
		}
		*/

		$selfat = "";
		$vfats = explode(":",$this->cfat);
		if (count($vfats) > 1){
			foreach ($vfats as $vlf) {
				if (strlen(trim($vlf)) > 0){
					if ($vlf > 0){
						$selfat .= "co_cidadao = ".$vlf." OR ";
					}
				}
			}
			if (strlen($selfat) > 17){
				$selfat = substr($selfat,0,-4);
			}
		} else {
			$selfat = "co_cidadao = ".$vfats[0];
		}

		// --------------------------------------------------------------------
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "(nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "]))";
		}
		// --------------------------------------------------------------------
		$tempo1 = "";
		if (($dti+$dtf) > 0){
			$tempo1 = "(co_dim_tempo >= '".$dti."' AND co_dim_tempo <= '".$dtf."')";
		}
		// --------------------------------------------------------------------
		$timub = "";
		if (count($this->imunos) > 0){
			$timub = "(imuno LIKE ANY (array[";
			foreach ($this->imunos as $v) {
				$timub .= "'".$v."',";
			}
			$timub = substr($timub,0,-1);
			$timub .= "]))";
		}
		$where = "";
		if (strlen($tcbos) > 0 || strlen($tempo1) > 0 || strlen($timub) > 0){
			$where = "WHERE ";
			if (strlen($tcbos) > 0){
				$where .= $tcbos;
				if (strlen($tempo1) > 0){
					$where .= " AND ".$tempo1;
					if (strlen($timub) > 0){
						$where .= " AND ".$timub;
					}
				} else {
					if (strlen($timub) > 0){
						$where .= " AND ".$timub;
					}
				}
			} else {
				if (strlen($tempo1) > 0){
					$where .= $tempo1;
					if (strlen($timub) > 0){
						$where .= " AND ".$timub;
					}
				} else {
					if (strlen($timub) > 0){
						$where .= $timub;
					}
				}
			}
		}
		// --------------------------------------------------------------------
		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					text '000000000000000' as nu_cns,
					text '00000000000' as nu_cpf_cidadao,
					TO_CHAR(t12.dt_aplicacao, 'YYYYMMDD') as co_dim_tempo,
					TO_CHAR(t12.dt_aplicacao, 'YYYYMMDD') as co_dim_tempo_vacina_aplicada,
					t12.dt_aplicacao,
					t12.dt_aprazamento,
					t12.ds_lote AS no_lote,
					t12.no_fabricante,
					t12.st_registro_anterior,
					t12.nu_cns AS nu_cns_prof,
					t12.no_profissional,
					TO_CHAR(t12.co_imunobiologico, 'FM999') as imuno,
					t12.sg_imunobiologico,
					t12.no_imunobiologico,
					tb_cbo.co_cbo_2002 AS nu_cbo,
					tb_cbo.no_cbo,
					t12.nu_cnes,
					t12.no_unidade_saude,
					t12.nu_ine,
					t12.no_equipe,
					t12.co_dose_imunobiologico AS dose,
					int '0' as co_fat_cidadao_pec
				FROM
				(
					SELECT
						t11.*,
						tb_equipe.nu_ine,
						tb_equipe.no_equipe
					FROM
					(
						SELECT
							t10.*,
							tb_unidade_saude.nu_cnes,
							tb_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT 
								t9.*,
								tb_atend.co_unidade_saude,
								tb_atend.co_equipe
							FROM
							(
								SELECT
									t8.*,
									tb_prof.nu_cpf, 
									tb_prof.nu_cns, 
									tb_prof.no_profissional
								FROM
								(
									SELECT
										t7.*,
										tb_lotacao.co_prof,
										tb_lotacao.co_cbo
									FROM
									(
										SELECT
											t6.*,
											tb_atend_prof.co_atend,
											tb_atend_prof.co_lotacao,
											tb_atend_prof.co_seq_atend_prof
										FROM
										(
											SELECT 
												t5.*,
												tb_imunobiologico_fabricante.no_fabricante
											FROM
											(
												SELECT
													t4.*,
													tb_imunobiologico_lote.ds_lote,
													tb_imunobiologico_lote.co_imunobiologico_fabricante
												FROM
												(
													SELECT 
														t3.*,
														tb_imunobiologico.sg_imunobiologico,
														tb_imunobiologico.no_imunobiologico
													FROM
													(
														SELECT
															tb_registro_vacinacao.co_imunobiologico,
															tb_registro_vacinacao.co_dose_imunobiologico,
															tb_registro_vacinacao.st_registro_anterior,
															tb_registro_vacinacao.dt_aplicacao,
															tb_registro_vacinacao.dt_aprazamento,
															tb_registro_vacinacao.co_imunobiologico_lote,
															tb2.co_atend_prof
														FROM
														(
															SELECT 
																tb_vacinacao.co_seq_vacinacao,
																tb_vacinacao.co_atend_prof
															FROM
															(
																SELECT
																	co_seq_prontuario
																FROM 
																	tb_prontuario
																WHERE
																	(".$selfat.")
															) AS tb1
															JOIN
																tb_vacinacao
															ON tb_vacinacao.co_prontuario = tb1.co_seq_prontuario
														) AS tb2
														JOIN
															tb_registro_vacinacao
														ON tb_registro_vacinacao.co_vacinacao = tb2.co_seq_vacinacao
													) AS t3
													LEFT JOIN
														tb_imunobiologico
													ON tb_imunobiologico.co_imunobiologico = t3.co_imunobiologico
												) t4
												LEFT JOIN
													tb_imunobiologico_lote
												ON tb_imunobiologico_lote.co_seq_imunobiologico_lote = t4.co_imunobiologico_lote
											) AS t5
											LEFT JOIN
												tb_imunobiologico_fabricante
											ON tb_imunobiologico_fabricante.co_seq_imunobiologico_fabrcnt = t5.co_imunobiologico_fabricante
										) AS t6
										LEFT JOIN
											tb_atend_prof
										ON tb_atend_prof.co_seq_atend_prof = t6.co_atend_prof
									) AS t7
									LEFT JOIN
										tb_lotacao
									ON tb_lotacao.co_ator_papel = t7.co_lotacao
								) AS t8
								LEFT JOIN
									tb_prof
								ON tb_prof.co_seq_prof = t8.co_prof
							) AS t9
							LEFT JOIN
								tb_atend
							ON tb_atend.co_seq_atend = t9.co_atend
						) AS t10
						LEFT JOIN
							tb_unidade_saude
						ON tb_unidade_saude.co_seq_unidade_saude = t10.co_unidade_saude
					) AS t11
					LEFT JOIN
						tb_equipe
					ON tb_equipe.co_seq_equipe = t11.co_equipe
				) AS t12
				LEFT JOIN
					tb_cbo
				ON tb_cbo.co_cbo = t12.co_cbo
				WHERE dt_aplicacao NOTNULL
			) AS t13
			".$where."
			ORDER BY imuno, dose, co_dim_tempo_vacina_aplicada
		";
		// --------------------------------------------------------------------
		$this->sql2 = "
			SELECT
				nu_cns,
				nu_cpf_cidadao,
				co_dim_tempo,
				co_dim_tempo_vacina_aplicada,
				no_lote,
				no_fabricante,
				st_registro_anterior,
				nu_cns_prof,
				no_profissional,
				imuno,
				sg_imunobiologico,
				no_imunobiologico,
				nu_cbo,
				no_cbo,
				nu_cnes,
				no_unidade_saude,
				nu_ine,
				no_equipe,
				dose,
				co_fat_cidadao_pec
			FROM
			(
				SELECT
					t6.*,
					tb_dim_dose_imunobiologico.nu_identificador AS dose,
					tb_dim_dose_imunobiologico.sg_dose_imunobiologico,
					tb_dim_dose_imunobiologico.no_dose_imunobiologico
				FROM
				(
					SELECT
						t5.*,
						tb_dim_equipe.nu_ine,
						tb_dim_equipe.no_equipe
					FROM
					(
						SELECT 
							t4.*,
							tb_dim_unidade_saude.nu_cnes,
							tb_dim_unidade_saude.no_unidade_saude
						FROM
						(
							SELECT
								t3.*,
								tb_dim_cbo.nu_cbo,
								tb_dim_cbo.no_cbo
							FROM
							(
								SELECT
									t2.*,
									tb_dim_imunobiologico.nu_identificador AS imuno,
									tb_dim_imunobiologico.sg_imunobiologico,
									tb_dim_imunobiologico.no_imunobiologico
								FROM
								(
									SELECT
										t1.*,
										tb_dim_profissional.nu_cns AS nu_cns_prof,
										tb_dim_profissional.no_profissional
									FROM
									(
										SELECT
											tb2.*,
											tb_fat_vacinacao_vacina.co_fat_vacinacao,
											tb_fat_vacinacao_vacina.co_dim_profissional,
											tb_fat_vacinacao_vacina.co_dim_cbo,
											tb_fat_vacinacao_vacina.co_dim_unidade_saude,
											tb_fat_vacinacao_vacina.co_dim_equipe,
											tb_fat_vacinacao_vacina.co_dim_tempo, 
											tb_fat_vacinacao_vacina.co_dim_imunobiologico, 
											tb_fat_vacinacao_vacina.co_dim_dose_imunobiologico, 
											tb_fat_vacinacao_vacina.no_lote, 
											tb_fat_vacinacao_vacina.no_fabricante, 
											tb_fat_vacinacao_vacina.st_registro_anterior,
											tb_fat_vacinacao_vacina.co_dim_tempo_vacina_aplicada
										FROM
										(
											SELECT
												tb1.*,
												tb_fat_vacinacao.co_seq_fat_vacinacao, 
												tb_fat_vacinacao.co_fat_cidadao_pec,
												tb_fat_vacinacao.dt_nascimento,
												tb_fat_vacinacao.nu_cns,
												tb_fat_vacinacao.nu_cpf_cidadao
											FROM
											(
												SELECT 
													co_seq_fat_cidadao_pec, 
													co_cidadao
												FROM
													tb_fat_cidadao_pec
												WHERE
													(".$selfat.")
											) AS tb1
											JOIN
												tb_fat_vacinacao
											ON tb_fat_vacinacao.co_fat_cidadao_pec = tb1.co_seq_fat_cidadao_pec
										) AS tb2
										JOIN
											tb_fat_vacinacao_vacina
										ON tb_fat_vacinacao_vacina.co_fat_vacinacao = tb2.co_seq_fat_vacinacao
									) AS t1
									JOIN
										tb_dim_profissional
									ON tb_dim_profissional.co_seq_dim_profissional = t1.co_dim_profissional
								) AS t2
								JOIN
									tb_dim_imunobiologico
								ON tb_dim_imunobiologico.co_seq_dim_imunobiologico = t2.co_dim_imunobiologico
							) AS t3
							JOIN
								tb_dim_cbo
							ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
						) AS t4
						JOIN
							tb_dim_unidade_saude
						ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t4.co_dim_unidade_saude
					) As t5
					JOIN
						tb_dim_equipe
					ON tb_dim_equipe.co_seq_dim_equipe = t5.co_dim_equipe
				) AS t6
				JOIN
					tb_dim_dose_imunobiologico
				ON tb_dim_dose_imunobiologico.co_seq_dim_dose_imunobiologico = t6.co_dim_dose_imunobiologico
			) AS t7
			".$where."
			ORDER BY imuno, dose, co_dim_tempo_vacina_aplicada
		";
		// --------------------------------------------------------------------

	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function todos(){
		$this->vacinas = array();
		$conta_array = 0;
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->vacinas[$conta_array]['ctrl'] = $rows->co_dim_tempo_vacina_aplicada.$rows->no_lote.$rows->no_fabricante.$rows->st_registro_anterior.$rows->imuno.$rows->nu_cns_prof;
					$this->vacinas[$conta_array]['cns'] = $rows->nu_cns;
					$this->vacinas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->vacinas[$conta_array]['dtVacina'] = $rows->co_dim_tempo_vacina_aplicada;
					$this->vacinas[$conta_array]['ine'] = $rows->nu_ine;
					$this->vacinas[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->vacinas[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->vacinas[$conta_array]['lote'] = $rows->no_lote;
					$this->vacinas[$conta_array]['fabricante'] = $rows->no_fabricante;
					$this->vacinas[$conta_array]['cnsProfissional'] = $rows->nu_cns_prof;
					$this->vacinas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
					$this->vacinas[$conta_array]['tabela'] = "vacinas";
					$this->vacinas[$conta_array]['regAnterior'] = $rows->st_registro_anterior;
					$this->vacinas[$conta_array]['dose'] = $rows->dose;
					$this->vacinas[$conta_array]['imuno'] = $rows->imuno;
					$this->vacinas[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->vacinas[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->vacinas[$conta_array]['equipe'] = $rows->no_equipe;
					$this->vacinas[$conta_array]['sgImuno'] = $rows->sg_imunobiologico;
					$this->vacinas[$conta_array]['noImuno'] = $rows->no_imunobiologico;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$conta_array++;
				}
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$ctrl_dup = $rows->co_dim_tempo_vacina_aplicada.$rows->no_lote.$rows->no_fabricante.$rows->st_registro_anterior.$rows->imuno.$rows->nu_cns_prof;
					if (false !== $key = array_search($ctrl_dup, array_column($this->vacinas, 'ctrl'))) {
						// encontrou duplicado
						if (strlen($rows->no_fabricante) > 0 && strlen($this->vacinas[$key]['fabricante']) <= 0){
							$this->vacinas[$key]['fabricante'] = $rows->no_fabricante;
						}
					} else {
						$this->vacinas[$conta_array]['ctrl'] = $ctrl_dup;
						$this->vacinas[$conta_array]['cns'] = $rows->nu_cns;
						$this->vacinas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
						$this->vacinas[$conta_array]['dtVacina'] = $rows->co_dim_tempo_vacina_aplicada;
						$this->vacinas[$conta_array]['ine'] = $rows->nu_ine;
						$this->vacinas[$conta_array]['cnes'] = $rows->nu_cnes;
						$this->vacinas[$conta_array]['cbo'] = $rows->nu_cbo;
						$this->vacinas[$conta_array]['lote'] = $rows->no_lote;
						$this->vacinas[$conta_array]['fabricante'] = $rows->no_fabricante;
						$this->vacinas[$conta_array]['cnsProfissional'] = $rows->nu_cns_prof;
						$this->vacinas[$conta_array]['nomeProfissional'] = $rows->no_profissional;
						$this->vacinas[$conta_array]['tabela'] = "fat_vacinas";
						$this->vacinas[$conta_array]['regAnterior'] = $rows->st_registro_anterior;
						$this->vacinas[$conta_array]['dose'] = $rows->dose;
						$this->vacinas[$conta_array]['imuno'] = $rows->imuno;
						$this->vacinas[$conta_array]['ocupacao'] = $rows->no_cbo;
						$this->vacinas[$conta_array]['unidade'] = $rows->no_unidade_saude;
						$this->vacinas[$conta_array]['equipe'] = $rows->no_equipe;
						$this->vacinas[$conta_array]['sgImuno'] = $rows->sg_imunobiologico;
						$this->vacinas[$conta_array]['noImuno'] = $rows->no_imunobiologico;
						$this->vacinas[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
						$conta_array++;
					}
				}
			}
		}
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
    public function total() {
		$this->vacinas = array();
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
			}
		}
		$rs = $this->con->query($this->sql2);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $this->totalEncontrado + $rs->rowCount();
				$this->ok = true;
			}
		}
    }
	
	private function array_sort($array, $on, $order=SORT_ASC){ //SORT_DESC
		$new_array = array();
		$sortable_array = array();

		if (count($array) > 0) {
			foreach ($array as $k => $v) {
				if (is_array($v)) {
					foreach ($v as $k2 => $v2) {
						if ($k2 == $on) {
							$sortable_array[$k] = $v2;
						}
					}
				} else {
					$sortable_array[$k] = $v;
				}
			}

			switch ($order) {
				case SORT_ASC:
					asort($sortable_array);
				break;
				case SORT_DESC:
					arsort($sortable_array);
				break;
			}

			foreach ($sortable_array as $k => $v) {
				$new_array[$k] = $array[$k];
			}
		}

		return $new_array;
	}
	
}

// **************************************************************************************************************************************************************
// **************************************************************************************************************************************************************
// **************************************************************************************************************************************************************
// **************************************************************************************************************************************************************
// **************************************************************************************************************************************************************

class VacinasFAT {
    public $dti;
	public $dtf;
	public $cfat;
	public $totalEncontrado;
	public $vacinas = array();
	public $ok;
	public $sql1;
	public $sql2;
	
	private $con;
	private $imunos;
	private $doses;
	private $cbos;

    public function __construct($con, $cfat, $cbos, $imunos, $doses, $dti = 0, $dtf = 0) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->cfat = $cfat;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->con = $con;
		$this->cbos = $cbos;
		$this->imunos = $imunos;
		$this->doses = $doses;

		// --------------------------------------------------------------------
		$selfat = "";
		if (trim(strlen($this->cfat) > 0)){
			$vfats = explode(":",$this->cfat);
			if (count($vfats) > 1){
				foreach ($vfats as $vlf) {
					if (strlen(trim($vlf)) > 0){
						if ($vlf > 0){
							$selfat .= "co_fat_cidadao_pec = ".$vlf." OR ";
						}
					}
				}
				$selfat = substr($selfat,0,-4);
				$selfat = "(".$selfat.")";
			} else {
				$selfat = "co_fat_cidadao_pec = ".$vfats[0];
			}
		}
		// --------------------------------------------------------------------
		$tdose = "";
		if (count($this->doses) > 0){
			$tdose = "ds_filtro_dose_imunobiologico LIKE ANY (array[";
			foreach ($this->doses as $v) {
				$tdose .= "'%|".$v."|%',";
			}
			$tdose = substr($tdose,0,-1);
			$tdose .= "])";
		}
		// --------------------------------------------------------------------
		$timub = "";
		if (count($this->imunos) > 0){
			$timub = "ds_filtro_imunobiologico LIKE ANY (array[";
			foreach ($this->imunos as $v) {
				$timub .= "'%|".$v."|%',";
			}
			$timub = substr($timub,0,-1);
			$timub .= "])";
		}
		// --------------------------------------------------------------------
		$where_main = "";
		if (strlen($selfat) > 0 || strlen($tdose) > 0 || strlen($timub) > 0){
			$where_main = "WHERE ";
			if (strlen($selfat) > 0){
				$where_main .= $selfat;
				if (strlen($tdose) > 0){
					$where_main .= " AND ".$tdose;
					if (strlen($timub) > 0){
						$where_main .= " AND ".$timub;
					}
				} else {
					if (strlen($timub) > 0){
						$where_main .= " AND ".$timub;
					}
				}
			} else {
				if (strlen($tdose) > 0){
					$where_main .= $tdose;
					if (strlen($timub) > 0){
						$where_main .= " AND ".$timub;
					}
				} else {
					if (strlen($timub) > 0){
						$where_main .= $timub;
					}
				}
			}
		}

		// --------------------------------------------------------------------
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}
		// --------------------------------------------------------------------
		$tempo1 = "";
		if (($dti+$dtf) > 0){
			$tempo1 = "(co_dim_tempo_vacina_aplicada >= '".$dti."' AND co_dim_tempo_vacina_aplicada <= '".$dtf."')";
		}
		// --------------------------------------------------------------------
		$where = "";
		if (strlen($tcbos) > 0 || strlen($tempo1) > 0){
			$where = "WHERE ";
			if (strlen($tcbos) > 0){
				$where .= $tcbos;
				if (strlen($tempo1) > 0){
					$where .= " AND ".$tempo1;
				}
			} else {
				if (strlen($tempo1) > 0){
					$where .= $tempo1;
				}
			}
		}
		// --------------------------------------------------------------------
		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT
					t8.*,
					tb_dim_dose_imunobiologico.nu_identificador AS dose_nu_identificador,
					tb_dim_dose_imunobiologico.sg_dose_imunobiologico,
					tb_dim_dose_imunobiologico.no_dose_imunobiologico,
					tb_dim_dose_imunobiologico.no_apresentacao_dose,
					tb_dim_dose_imunobiologico.nu_ordem AS dose_nu_ordem
				FROM
				(
					SELECT
						t7.*,
						tb_dim_estrategia_vacinacao.nu_estrategia_vacinacao,
						tb_dim_estrategia_vacinacao.no_estrategia_vacinacao
					FROM
					(
						SELECT
							t6.*,
							tb_dim_imunobiologico.nu_identificador,
							tb_dim_imunobiologico.sg_imunobiologico,
							tb_dim_imunobiologico.no_imunobiologico
						FROM
						(
							SELECT
								t5.*,
								tb_dim_equipe.nu_ine,
								tb_dim_equipe.no_equipe
							FROM
							(
								SELECT
									t4.*,
									tb_dim_unidade_saude.nu_cnes,
									tb_dim_unidade_saude.no_unidade_saude,
									tb_dim_unidade_saude.no_bairro
								FROM
								(
									SELECT
										t3.*,
										tb_dim_cbo.nu_cbo,
										tb_dim_cbo.no_cbo
									FROM
									(
										SELECT
											t2.*,
											tb_dim_profissional.nu_cns AS prof_cns,
											tb_dim_profissional.no_profissional AS prof_nome
										FROM
										(
											SELECT
												t1.*,
												tb_fat_vacinacao_vacina.co_seq_fat_vacinacao_vacina, 
												tb_fat_vacinacao_vacina.co_dim_profissional, 
												tb_fat_vacinacao_vacina.co_dim_cbo, 
												tb_fat_vacinacao_vacina.co_dim_unidade_saude, 
												tb_fat_vacinacao_vacina.co_dim_equipe, 
												tb_fat_vacinacao_vacina.co_dim_tempo, 
												tb_fat_vacinacao_vacina.co_dim_imunobiologico, 
												tb_fat_vacinacao_vacina.co_dim_estrategia_vacinacao, 
												tb_fat_vacinacao_vacina.co_dim_dose_imunobiologico, 
												tb_fat_vacinacao_vacina.no_lote, 
												tb_fat_vacinacao_vacina.no_fabricante, 
												tb_fat_vacinacao_vacina.co_dim_grupo_atendimento, 
												tb_fat_vacinacao_vacina.st_registro_anterior, 
												tb_fat_vacinacao_vacina.co_dim_tempo_vacina_aplicada, 
												tb_fat_vacinacao_vacina.st_aplicado_exterior
											FROM
											(
												SELECT 
													co_seq_fat_vacinacao, 
													co_dim_tempo, 
													nu_cns, 
													dt_nascimento, 
													co_dim_sexo, 
													co_fat_cidadao_pec, 
													nu_cpf_cidadao
												FROM 
													tb_fat_vacinacao
												".$where_main."
													-- data do registro
													--AND (co_dim_tempo >= 20220110 AND co_dim_tempo <= 20230110)
											) AS t1
											LEFT JOIN
												tb_fat_vacinacao_vacina
											ON co_fat_vacinacao = t1.co_seq_fat_vacinacao
										) AS t2
										LEFT JOIN
											tb_dim_profissional
										ON tb_dim_profissional.co_seq_dim_profissional = t2.co_dim_profissional
									) AS t3
									LEFT JOIN
										tb_dim_cbo
									ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
								) AS t4
								LEFT JOIN
									tb_dim_unidade_saude
								ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t4.co_dim_unidade_saude
							) AS t5
							LEFT JOIN
								tb_dim_equipe
							ON tb_dim_equipe.co_seq_dim_equipe = t5.co_dim_equipe
						) AS t6
						LEFT JOIN
							tb_dim_imunobiologico
						ON tb_dim_imunobiologico.co_seq_dim_imunobiologico = t6.co_dim_imunobiologico
					) AS t7
					LEFT JOIN
						tb_dim_estrategia_vacinacao
					ON tb_dim_estrategia_vacinacao.co_seq_dim_estrategia_vacnacao = t7.co_dim_estrategia_vacinacao
				) AS t8
				LEFT JOIN
					tb_dim_dose_imunobiologico
				ON tb_dim_dose_imunobiologico.co_seq_dim_dose_imunobiologico = t8.co_dim_dose_imunobiologico
			) AS t9
			".$where."
		";
		// --------------------------------------------------------------------
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	public function todos(){
		$this->vacinas = array();
		$conta_array = 0;
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->vacinas[$conta_array]['ctrl'] = $rows->co_dim_tempo_vacina_aplicada.$rows->no_lote.$rows->no_fabricante.$rows->st_registro_anterior.$rows->nu_identificador.$rows->prof_cns;

					/*
					$this->vacinas[$conta_array]['idfat'] = $rows->co_seq_fat_vacinacao;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_tempo;
					$this->vacinas[$conta_array]['idfat'] = $rows->dt_nascimento;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_sexo;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_seq_fat_vacinacao_vacina;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_profissional;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_cbo;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_unidade_saude;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_equipe;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_tempo;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_imunobiologico;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_estrategia_vacinacao;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_dose_imunobiologico;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_dim_grupo_atendimento;
					$this->vacinas[$conta_array]['idfat'] = $rows->st_aplicado_exterior;
					$this->vacinas[$conta_array]['idfat'] = $rows->no_bairro;
					$this->vacinas[$conta_array]['idfat'] = $rows->nu_identificador;
					$this->vacinas[$conta_array]['idfat'] = $rows->nu_estrategia_vacinacao;
					$this->vacinas[$conta_array]['idfat'] = $rows->no_estrategia_vacinacao;
					$this->vacinas[$conta_array]['idfat'] = $rows->sg_dose_imunobiologico;
					$this->vacinas[$conta_array]['idfat'] = $rows->no_dose_imunobiologico;
					$this->vacinas[$conta_array]['idfat'] = $rows->no_apresentacao_dose;
					$this->vacinas[$conta_array]['idfat'] = $rows->dose_nu_ordem;
					*/

					$this->vacinas[$conta_array]['imuno'] = $rows->nu_identificador;
					$this->vacinas[$conta_array]['cns'] = $rows->nu_cns;
					$this->vacinas[$conta_array]['idfat'] = $rows->co_fat_cidadao_pec;
					$this->vacinas[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->vacinas[$conta_array]['lote'] = $rows->no_lote;
					$this->vacinas[$conta_array]['fabricante'] = $rows->no_fabricante;
					$this->vacinas[$conta_array]['regAnterior'] = $rows->st_registro_anterior;
					$this->vacinas[$conta_array]['dtVacina'] = $rows->co_dim_tempo_vacina_aplicada;
					$this->vacinas[$conta_array]['cnsProfissional'] = $rows->prof_cns;
					$this->vacinas[$conta_array]['nomeProfissional'] = $rows->prof_nome;
					$this->vacinas[$conta_array]['cbo'] = $rows->nu_cbo;
					$this->vacinas[$conta_array]['ocupacao'] = $rows->no_cbo;
					$this->vacinas[$conta_array]['cnes'] = $rows->nu_cnes;
					$this->vacinas[$conta_array]['unidade'] = $rows->no_unidade_saude;
					$this->vacinas[$conta_array]['ine'] = $rows->nu_ine;
					$this->vacinas[$conta_array]['equipe'] = $rows->no_equipe;
					$this->vacinas[$conta_array]['sgImuno'] = $rows->sg_imunobiologico;
					$this->vacinas[$conta_array]['noImuno'] = $rows->no_imunobiologico;
					$this->vacinas[$conta_array]['dose'] = $rows->dose_nu_identificador;
					$this->vacinas[$conta_array]['tabela'] = "fat_vacinas";

					$conta_array++;
				}
			}
		}
	}

	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
	// *************************************************************************************************************************
    public function total() {
		$this->vacinas = array();
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->totalEncontrado = $rs->rowCount();
				$this->ok = true;
			}
		}
    }
	
	private function array_sort($array, $on, $order=SORT_ASC){ //SORT_DESC
		$new_array = array();
		$sortable_array = array();

		if (count($array) > 0) {
			foreach ($array as $k => $v) {
				if (is_array($v)) {
					foreach ($v as $k2 => $v2) {
						if ($k2 == $on) {
							$sortable_array[$k] = $v2;
						}
					}
				} else {
					$sortable_array[$k] = $v;
				}
			}

			switch ($order) {
				case SORT_ASC:
					asort($sortable_array);
				break;
				case SORT_DESC:
					arsort($sortable_array);
				break;
			}

			foreach ($sortable_array as $k => $v) {
				$new_array[$k] = $array[$k];
			}
		}

		return $new_array;
	}
	
}













/*
SELECT
	*
FROM
(
	SELECT
		t8.*,
		tb_dim_dose_imunobiologico.nu_identificador AS dose_nu_identificador,
		tb_dim_dose_imunobiologico.sg_dose_imunobiologico,
		tb_dim_dose_imunobiologico.no_dose_imunobiologico,
		tb_dim_dose_imunobiologico.no_apresentacao_dose,
		tb_dim_dose_imunobiologico.nu_ordem AS dose_nu_ordem
	FROM
	(
		SELECT
			t7.*,
			tb_dim_estrategia_vacinacao.nu_estrategia_vacinacao,
			tb_dim_estrategia_vacinacao.no_estrategia_vacinacao
		FROM
		(
			SELECT
				t6.*,
				tb_dim_imunobiologico.nu_identificador,
				tb_dim_imunobiologico.sg_imunobiologico,
				tb_dim_imunobiologico.no_imunobiologico
			FROM
			(
				SELECT
					t5.*,
					tb_dim_equipe.nu_ine,
					tb_dim_equipe.no_equipe
				FROM
				(
					SELECT
						t4.*,
						tb_dim_unidade_saude.nu_cnes,
						tb_dim_unidade_saude.no_unidade_saude,
						tb_dim_unidade_saude.no_bairro
					FROM
					(
						SELECT
							t3.*,
							tb_dim_cbo.nu_cbo,
							tb_dim_cbo.no_cbo
						FROM
						(
							SELECT
								t2.*,
								tb_dim_profissional.nu_cns AS prof_cns,
								tb_dim_profissional.no_profissional AS prof_nome
							FROM
							(
								SELECT
									t1.*,
									tb_fat_vacinacao_vacina.co_seq_fat_vacinacao_vacina, 
									tb_fat_vacinacao_vacina.co_dim_profissional, 
									tb_fat_vacinacao_vacina.co_dim_cbo, 
									tb_fat_vacinacao_vacina.co_dim_unidade_saude, 
									tb_fat_vacinacao_vacina.co_dim_equipe, 
									tb_fat_vacinacao_vacina.co_dim_tempo, 
									tb_fat_vacinacao_vacina.co_dim_imunobiologico, 
									tb_fat_vacinacao_vacina.co_dim_estrategia_vacinacao, 
									tb_fat_vacinacao_vacina.co_dim_dose_imunobiologico, 
									tb_fat_vacinacao_vacina.no_lote, 
									tb_fat_vacinacao_vacina.no_fabricante, 
									tb_fat_vacinacao_vacina.co_dim_grupo_atendimento, 
									tb_fat_vacinacao_vacina.st_registro_anterior, 
									tb_fat_vacinacao_vacina.co_dim_tempo_vacina_aplicada, 
									tb_fat_vacinacao_vacina.st_aplicado_exterior
								FROM
								(
									SELECT 
										co_seq_fat_vacinacao, 
										co_dim_tempo, 
										nu_cns, 
										dt_nascimento, 
										co_dim_sexo, 
										co_fat_cidadao_pec, 
										nu_cpf_cidadao
									FROM 
										tb_fat_vacinacao
									WHERE 
										co_fat_cidadao_pec = 110688
										AND ds_filtro_imunobiologico LIKE ANY (array['%|22|%','%|42|%,%|43|%'])
										AND ds_filtro_dose_imunobiologico LIKE ANY (array['%|1|%','%|2|%','%|3|%'])
										-- data do registro
										--AND (co_dim_tempo >= 20220110 AND co_dim_tempo <= 20230110)
								) AS t1
								LEFT JOIN
									tb_fat_vacinacao_vacina
								ON co_fat_vacinacao = t1.co_seq_fat_vacinacao
							) AS t2
							LEFT JOIN
								tb_dim_profissional
							ON tb_dim_profissional.co_seq_dim_profissional = t2.co_dim_profissional
						) AS t3
						LEFT JOIN
							tb_dim_cbo
						ON tb_dim_cbo.co_seq_dim_cbo = t3.co_dim_cbo
					) AS t4
					LEFT JOIN
						tb_dim_unidade_saude
					ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t4.co_dim_unidade_saude
				) AS t5
				LEFT JOIN
					tb_dim_equipe
				ON tb_dim_equipe.co_seq_dim_equipe = t5.co_dim_equipe
			) AS t6
			LEFT JOIN
				tb_dim_imunobiologico
			ON tb_dim_imunobiologico.co_seq_dim_imunobiologico = t6.co_dim_imunobiologico
		) AS t7
		LEFT JOIN
			tb_dim_estrategia_vacinacao
		ON tb_dim_estrategia_vacinacao.co_seq_dim_estrategia_vacnacao = t7.co_dim_estrategia_vacinacao
	) AS t8
	LEFT JOIN
		tb_dim_dose_imunobiologico
	ON tb_dim_dose_imunobiologico.co_seq_dim_dose_imunobiologico = t8.co_dim_dose_imunobiologico
) AS t9
WHERE
	nu_cbo LIKE ANY (array['3222%','2235%','2231%'])
	AND (co_dim_tempo_vacina_aplicada >= 20220110 AND co_dim_tempo_vacina_aplicada <= 20230110)
*/








?>



