<?php
require_once('core/sec.php');

$passdb = '';
$rs = $con->prepare("SELECT * FROM sc_tb_usuarios WHERE login = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$passdb = $row->senha;
		}
	}
}

?>
<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Alteração de senha</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Altere sua senha</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                    <div class="row g-1 mb-md-1">

                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="nsenha">Senha</label>
				                    <input type="password" class="form-control" name="nsenha" id="nsenha">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="rnsenha">Repita a senha</label>
                            <input type="password" class="form-control" name="rnsenha" id="rnsenha" />
                        </div>

                        <button type="submit" class="btn btn-primary" id="button-addon2">Gravar</button>
                    </div>

                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
$(function () {
  $('#frm').validate({
    submitHandler: function (form) {
      if ($('#nsenha').val() == $('#rnsenha').val()){
        if ($('#nsenha').val().length >= 8){
          $.post('gv_senha.php', $('#frm').serialize(), function (data, textStatus) {
            if (data == 'Ok'){ // data.substring(0,2)
              swal.fire('Ok!','Senha alterada com sucesso!','success');
              $('.content-body').load('frm_senha.php');
            } else {
              swal.fire('erro!',data,'error');
            }
          });
        } else {
          swal.fire('erro!','A senha não tem no mínimo 8 caracteres','error');
        }
      } else {
        swal.fire('erro!','As senhas não são iguais','error');
      }
    },
    rules: {
        nsenha: {
          required: true
        },
        rnsenha: {
          required: true
        }
    },
    messages: {
        nsenha: {
          required: "Este campo é necessário"
        },
        rnsenha: {
          required: "Este campo é necessário"
        }
    }
  });
})
</script>