<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">CIDs e CIAPs</h4>
                </div>
                <div class="card-body mt-2">
<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$f_calibra = "calibracao.php";
if (file_exists($f_calibra)){
    include $f_calibra;
}

$dti = fgpa('i');
$dtf = fgpa('f');
$idin = 0;
$idfi = 150;
$cids = '';
$sexo = 'A';
$cpf = '';
$cns = '';
$ciaps = '';
$metodo = 1;
$sexo_moh = "T";

$rs = $con->prepare("SELECT * FROM cidadao_tb_cf_cidsciaps WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$dti = $row->dti;
			$dtf = $row->dtf;
            $idin = $row->idin;
            $idfi = $row->idfi;
            $cpf = $row->cpf;
            $cns = $row->cns;
            $cids = $row->cids;
            $sexo = $row->sexo;
            $ciaps = $row->ciaps;
            $metodo = $row->metodo;
		}
	}
}

$sexo_m = $sexo;
if ($sexo_m == 'A'){
    $sexo_m = "Ambos";
}
$metodo_m = $metodo;
if ($metodo_m == '1'){
    $metodo_m = "Apenas quem atende aos critérios";
} else {
    $metodo_m = "Todos";
}
echo "
                    <p class=\"card-text\">
                        Data inicial: ".datanas6($dti)." | Data final: ".datanas6($dtf)."<br>
                        Idade inicial: ".$idin." | Idade final: ".$idfi."<br>
                        CPF: ".$cpf."<br>
                        CNS: ".$cns."<br>
                        Sexo: ".$sexo_m."<br>
                        Método: ".$metodo_m."<br>
                        CIDs: ".$cids."<br>
                        CIAPs: ".$ciaps."<br>
                        Gerado em: ".date('d/m/Y H:i:s')."
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
";

// --------------------------------------------------------
$ar_cids = explode(";",$cids);
$vr_cids = false;
if (count($ar_cids) == 1){
    if (strlen($ar_cids[0]) > 0){
        $vr_cids = true;
    } else {
        $ar_cids = array();
    }
} elseif (count($ar_cids) > 1){
    $vr_cids = true;
} else {
    $ar_cids = array();
}
$ar_ciaps = explode(";",$ciaps);
$vr_ciaps = false;
if (count($ar_ciaps) == 1){
    if (strlen($ar_ciaps[0]) > 0){
        $vr_ciaps = true;
    } else {
        $ar_ciaps = array();
    }
} elseif (count($ar_ciaps) > 1){
    $vr_ciaps = true;
} else {
    $ar_ciaps = array();
}
// --------------------------------------------------------
$ar_cpf = explode(";",$cpf);
$vr_cpf = false;
if (count($ar_cpf) == 1){
    if (strlen($ar_cpf[0]) > 0){
        $vr_cpf = true;
    }
} elseif (count($ar_cpf) > 1){
    $vr_cpf = true;
}
// --------------------------------------------------------
$ar_cns = explode(";",$cns);
$vr_cns = false;
if (count($ar_cns) == 1){
    if (strlen($ar_cns[0]) > 0){
        $vr_cns = true;
    }
} elseif (count($ar_cns) > 1){
    $vr_cns = true;
}
// --------------------------------------------------------
if ($sexo == 'M'){
    $sexo_moh = "MASCULINO";
} elseif ($sexo == 'F'){
    $sexo_moh = "FEMININO";
}
// --------------------------------------------------------

include($path_local_raiz.'class/_cidadao.class.php');
include($path_local_raiz.'class/_consultas.class.php'); 

echo "
    <table id=\"tbdt\" class=\"table table-striped\">
    <thead>
        <tr>
            <th>TP</th>
            <th>CPF</th>
            <th>CNS</th>
            <th>Nome</th>
            <th>Mae</th>
            <th>DtNascimento</th>
            <th>Idade/Hoje</th>
            <th>CNS Prof.</th>
            <th>Profissional</th>
            <th>Data</th>
            <th>INE</th>
            <th>CNES</th>
            <th>CIAPs</th>
            <th>CIDs</th>
        </tr>
    </thead>
    <tbody>
";
$ctrl_duplicado = array();
$idinn = $idin*12;
$idfin = $idfi*12+11;
$cids = new Cidadaos($cdb, $sexo_moh, $idinn, $idfin, $dti, $dtf);
$cids->todos();
if ($cids->totalEncontrado > 0){
    for ($i=0;$i<count($cids->cidadaos);$i++){
        $pec_cid_cpf = $cids->cidadaos[$i]['cpf'];
        $pec_cid_cns = $cids->cidadaos[$i]['cns'];
        $pec_cid_nome = $cids->cidadaos[$i]['nome'];
        $pec_cid_mae = $cids->cidadaos[$i]['mae'];
        $pec_cid_dtnas = "0000-00-00";
        $pec_cid_dtnas = datanas2($cids->cidadaos[$i]['dtNascimento']);
        $idade = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),$dtf);
        $idade_hoje = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),date('Ymd'));
        $ctrl = $pec_cid_cpf.$pec_cid_cns.$pec_cid_nome.$pec_cid_mae;
        $mostrar = false;
        if ($vr_cpf){
            if (in_array($pec_cid_cpf, $ar_cpf)){
                $mostrar = true;
            }
        }
        if ($vr_cns){
            if (in_array($pec_cid_cns, $ar_cns)){
                $mostrar = true;
            }
        }
        if (!$vr_cpf && !$vr_cns){
            $mostrar = true;
        }
        if ($mostrar){
            if (strlen($cids->cidadaos[$i]['cidadao']) > 0){
                if (isset($calibracao_cidsciaps)){
                    if ($calibracao_cidsciaps == 'C'){
                        $ccs = new Consultas($cdb, $cids->cidadaos[$i]['cns'], $cids->cidadaos[$i]['cpf'], '', '', $dti, $dtf, $ar_ciaps, $ar_cids, array());
                    } else {
                        $ccs = new ConsultasFAT($cdb, $cids->cidadaos[$i]['cidadao'], $dti, $dtf, $ar_ciaps, $ar_cids, array());
                    }
                } else {
                    $ccs = new ConsultasFAT($cdb, $cids->cidadaos[$i]['cidadao'], $dti, $dtf, $ar_ciaps, $ar_cids, array());
                }
            } else {
                $ccs = new Consultas($cdb, $cids->cidadaos[$i]['cns'], $cids->cidadaos[$i]['cpf'], '', '', $dti, $dtf, $ar_ciaps, $ar_cids, array());
            }

            if ($scsus_demo){
                $pec_cid_cpf = "***.***.***-**";
                $pec_cid_cns = "***************";
                $pec_cid_nome = "********** ********* ***********";
                $pec_cid_mae = "******* ********** ************";
                $pec_cid_dtnas = "**/**/****";
            }

            $ccs->todos();
            if ($ccs->totalEncontrado > 0){
                for ($k=0;$k<count($ccs->consultas);$k++){
                    $cons_cids = str_replace(" ","",substr(substr($ccs->consultas[$k]['cids'],0,-1),1));
                    $cons_ciaps = str_replace(" ","",substr(substr($ccs->consultas[$k]['ciaps'],0,-1),1));
                    $ctrl .= $ccs->consultas[$k]['dtConsulta'].$cons_cids.$cons_ciaps;
                    $array_cons_cids = explode("|",$cons_cids);
                    $array_cons_ciaps = explode("|",$cons_ciaps);

                    $apenas_cids = array_intersect($array_cons_cids,$ar_cids);
                    $apenas_ciaps = array_intersect($array_cons_ciaps,$ar_ciaps);
                    $show_cons_cids = "";
                    if ($vr_cids){
                        foreach ($apenas_cids as $value1){
                            $show_cons_cids .= $value1."|";
                        }
                    } else {
                        foreach ($array_cons_cids as $value1){
                            $show_cons_cids .= $value1."|";
                        }
                    }
                    $show_cons_ciaps = "";
                    if ($vr_ciaps){
                        foreach ($apenas_ciaps as $value){
                            $show_cons_ciaps .= $value."|";
                        }
                    } else {
                        foreach ($array_cons_ciaps as $value){
                            $show_cons_ciaps .= $value."|";
                        }
                    }

                    $show_ccs_cnsprofissional = $ccs->consultas[$k]['cnsProfissional'];
                    $show_ccs_nomeprofissional = $ccs->consultas[$k]['nomeProfissional'];
                    $show_ccs_ine = $ccs->consultas[$k]['ine'];
                    $show_ccs_cnes = $ccs->consultas[$k]['cnes'];
                    if ($scsus_demo){
                        $show_ccs_cnsprofissional = "***************";
                        $show_ccs_nomeprofissional = "******** ********* ***********";
                        $show_ccs_ine = "0000******";
                        $show_ccs_cnes = "******";
                    }

                    $mostrar_det = true;
                    if ($mostrar_det){
                        if (!in_array($ctrl, $ctrl_duplicado)){
                            echo "<tr>";
                                echo "<td>SIM</td>";
                                echo "<td>".$pec_cid_cpf."</td>";
                                echo "<td>".$pec_cid_cns."</td>";
                                echo "<td>".$pec_cid_nome."</td>";
                                echo "<td>".$pec_cid_mae."</td>";
                                echo "<td>".$pec_cid_dtnas."</td>";
                                echo "<td>".$idade."/".$idade_hoje."</td>";
                                echo "<td>".$show_ccs_cnsprofissional."</td>";
                                echo "<td>".$show_ccs_nomeprofissional."</td>";
                                echo "<td>".datanas6($ccs->consultas[$k]['dtConsulta'])."</td>";
                                echo "<td>".$show_ccs_ine."</td>";
                                echo "<td>".$show_ccs_cnes."</td>";
                                echo "<td>".$show_cons_ciaps."</td>";
                                echo "<td>".$show_cons_cids."</td>";
                            echo "</tr>";
                            $ctrl_duplicado[] = $ctrl;
                        }
                    }
                }
            } else {
                if ($metodo == 2){
                    echo "<tr>";
                        echo "<td>NAO</td>";
                        echo "<td>".$pec_cid_cpf."</td>";
                        echo "<td>".$pec_cid_cns."</td>";
                        echo "<td>".$pec_cid_nome."</td>";
                        echo "<td>".$pec_cid_mae."</td>";
                        echo "<td>".$pec_cid_dtnas."</td>";
                        echo "<td>".$idade."/".$idade_hoje."</td>";
                        echo "<td></td>";
                        echo "<td></td>";
                        echo "<td></td>";
                        echo "<td></td>";
                        echo "<td></td>";
                        echo "<td></td>";
                        echo "<td></td>";
                    echo "</tr>";
                }
            }
        }
    }
}
echo "
    </tbody>
    </table>
";




?>
<script>
    SlickLoader.disable();
    $(document).ready(function() {
        $('#tbdt').DataTable({
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            },
            dom: 'Bfrtip',
            buttons: [
                'excelHtml5',
                'csvHtml5'
            ]
        });
    });
</script>