<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Hiperutilizador</h4>
                </div>
                <div class="card-body mt-2">
<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$f_calibra = "calibracao.php";
if (file_exists($f_calibra)){
    include $f_calibra;
}

$dti = fgpa('i');
$dtf = fgpa('f');
$idin = 0;
$idfi = 150;
$qtd = 100;
$sexo = 'A';
$sexo_moh = "T";

$rs = $con->prepare("SELECT * FROM cidadao_tb_cf_hiperutilizador WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$dti = $row->dti;
			$dtf = $row->dtf;
            $idin = $row->idin;
            $idfi = $row->idfi;
            $qtd = $row->qtd;
            $sexo = $row->sexo;
		}
	}
}

$sexo_m = $sexo;
if ($sexo_m == 'A'){
    $sexo_m = "Ambos";
}
echo "
                    <p class=\"card-text\">
                        Data inicial: ".datanas6($dti)." | Data final: ".datanas6($dtf)."<br>
                        Idade inicial: ".$idin." | Idade final: ".$idfi."<br>
                        Sexo: ".$sexo_m."<br>
                        Qtd: ".$qtd."<br>
                        Gerado em: ".date('d/m/Y H:i:s')."
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
";

// --------------------------------------------------------
if ($sexo == 'M'){
    $sexo_moh = "MASCULINO";
} elseif ($sexo == 'F'){
    $sexo_moh = "FEMININO";
}
// --------------------------------------------------------

include($path_local_raiz.'class/_cidadao.class.php');
include($path_local_raiz.'class/_procedimentos.class.php');
include($path_local_raiz.'class/_consultas.class.php');

echo "
    <table id=\"tbdt\" class=\"table table-striped\">
    <thead>
        <tr>
            <th>TV</th>
            <th>CPF</th>
            <th>CNS</th>
        </tr>
    </thead>
    <tbody>
";
$hiper = array();
$hiper_conta = 0;
$arcidadao = array();
$arcidadao_conta = 0;
$idinn = $idin*12;
$idfin = $idfi*12+11;
$cids = new Cidadaos($cdb, $sexo_moh, $idinn, $idfin, $dti, $dtf);
$cids->todos();
if ($cids->totalEncontrado > 0){
    for ($i=0;$i<count($cids->cidadaos);$i++){
        $pec_cid_cpf = $cids->cidadaos[$i]['cpf'];
        $pec_cid_cns = $cids->cidadaos[$i]['cns'];
        $pec_cid_nome = $cids->cidadaos[$i]['nome'];
        $pec_cid_mae = $cids->cidadaos[$i]['mae'];
        $pec_cid_dtnas = datanas2($cids->cidadaos[$i]['dtNascimento']);
        $idade = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),$dtf);
        $idade_hoje = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),date('Ymd'));
        $ctrl = $pec_cid_cpf.$pec_cid_cns.$pec_cid_nome.$pec_cid_mae;
        $mostrar = true;
        if ($scsus_demo){
            $pec_cid_cpf = "***.***.***-**";
            $pec_cid_cns = "***************";
            $pec_cid_nome = "********** ********* ***********";
            $pec_cid_mae = "******* ********** ************";
            $pec_cid_dtnas = "**/**/****";
        }

        if (strlen($cids->cidadaos[$i]['cidadao']) > 0){
            $arcidadao[$arcidadao_conta]['cidadao'] = $cids->cidadaos[$i]['cidadao'];
            $arcidadao[$arcidadao_conta]['dtnas1'] = $pec_cid_dtnas;
            $arcidadao[$arcidadao_conta]['cpf1'] = $pec_cid_cpf;
            $arcidadao[$arcidadao_conta]['cns1'] = $pec_cid_cns;
            $arcidadao[$arcidadao_conta]['nome1'] = $pec_cid_nome;
            $arcidadao[$arcidadao_conta]['mae1'] = $pec_cid_mae;
            $arcidadao[$arcidadao_conta]['dtnas2'] = datanas2($cids->cidadaos[$i]['dtNascimento']);
            $arcidadao[$arcidadao_conta]['cpf2'] = $cids->cidadaos[$i]['cpf'];
            $arcidadao[$arcidadao_conta]['cns2'] = $cids->cidadaos[$i]['cns'];
            $arcidadao[$arcidadao_conta]['nome2'] = $cids->cidadaos[$i]['nome'];
            $arcidadao[$arcidadao_conta]['mae2'] = $cids->cidadaos[$i]['mae'];
            $arcidadao[$arcidadao_conta]['idade'] = $idade;
            $arcidadao[$arcidadao_conta]['total'] = 0;
            $arcidadao_conta++;

            //-----------------------------------------------------------------------------------------------------------------
            //-----------------------------------------------------------------------------------------------------------------
            $procs = new ProcedimentosFAT($cdb, $cids->cidadaos[$i]['cidadao'], $dti, $dtf, array(), array());
            $procs->todos();
            if ($procs->totalEncontrado > 0){
                for ($k=0;$k<count($procs->procedimentos);$k++){
                    $ctrl = $procs->procedimentos[$k]['dtConsulta'].$cids->cidadaos[$i]['cidadao'];
                    if (false !== $key = array_search($ctrl, array_column($hiper, 'ctrl'))) {
                        //
                    } else {
                        $hiper[$hiper_conta]['ctrl'] = $ctrl;
                        $hiper[$hiper_conta]['cidadao'] = $cids->cidadaos[$i]['cidadao'];
                        $hiper_conta++;
                    }
                }
            }
            //-----------------------------------------------------------------------------------------------------------------
            //-----------------------------------------------------------------------------------------------------------------
            $ccs = new ConsultasFAT($cdb, $cids->cidadaos[$i]['cidadao'], $dti, $dtf, array(), array(), array());
            $ccs->todos();
            if ($ccs->totalEncontrado > 0){
                for ($k=0;$k<count($ccs->consultas);$k++){
                    $ctrl = $ccs->consultas[$k]['dtConsulta'].$cids->cidadaos[$i]['cidadao'];
                    if (false !== $key = array_search($ctrl, array_column($hiper, 'ctrl'))) {
                        //
                    } else {
                        $hiper[$hiper_conta]['ctrl'] = $ctrl;
                        $hiper[$hiper_conta]['cidadao'] = $cids->cidadaos[$i]['cidadao'];
                        $hiper_conta++;
                    }
                }
            }
        }
    }
}
$somatorio = array_count_values(array_column($hiper, 'cidadao'));
for ($i=0;$i<count($arcidadao);$i++){
    if (isset($somatorio[$arcidadao[$i]['cidadao']])) {
        $arcidadao[$i]['total'] = $somatorio[$arcidadao[$i]['cidadao']];
    }
}
$total = array_column($arcidadao, 'total');
$cidadaox = array_column($arcidadao, 'cidadao');
$dtnas1 = array_column($arcidadao, 'dtnas1');
$cpf1 = array_column($arcidadao, 'cpf1');
$cns1 = array_column($arcidadao, 'cns1');
$nome1 = array_column($arcidadao, 'nome1');
$mae1 = array_column($arcidadao, 'mae1');
$dtnas2 = array_column($arcidadao, 'dtnas2');
$cpf2 = array_column($arcidadao, 'cpf2');
$cns2 = array_column($arcidadao, 'cns2');
$nome2 = array_column($arcidadao, 'nome2');
$mae2 = array_column($arcidadao, 'mae2');
$idade = array_column($arcidadao, 'idade');
array_multisort($total, SORT_NUMERIC, SORT_DESC, $cidadaox, $dtnas1, $cpf1, $cns1, $nome1, $mae1, $dtnas2, $cpf2, $cns2, $nome2, $mae2, $idade);

$total_for = count($total);
if (count($total) > $qtd){
    $total_for = $qtd;
}

for ($i=0;$i<$total_for;$i++){
    echo "<tr>";
        echo "<td>".$total[$i]."</td>";
        echo "<td>".$nome2[$i]."</td>";
        echo "<td>".$cidadaox[$i]."</td>";
    echo "</tr>";
}
echo "
    </tbody>
</table>
";



?>
<script>
    SlickLoader.disable();
    $(document).ready(function() {
        $('#tbdt').DataTable({
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            },
            dom: 'Bfrtip',
            buttons: [
                'excelHtml5',
                'csvHtml5'
            ]
        });
    });
</script>