<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$cfg_largura = $cfgeral_largura;
$cfg_altura = $cfgeral_altura;
$cfg_latitude = $cfgeral_latitude;
$cfg_longitude = $cfgeral_longitude;
$cfg_zoom = $cfgeral_zoom;

$rs = $con->prepare("SELECT * FROM maps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
      $cfg_largura = $row->largura;
      $cfg_altura = $row->altura;
      $cfg_latitude = $row->latitude;
      $cfg_longitude = $row->longitude;
      $cfg_zoom = $row->zoom;
		}
	}
}



?>
<link rel="stylesheet" type="text/css" href="mod/maps/leaflet/leaflet.css">

<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Mapa</h4>
                </div>
                <div class="card-body mt-2">

                  <div id='mapf' style="width: <?php echo $cfg_largura;?>; height: <?php echo $cfg_altura;?>;"></div>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Focos</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Parâmetros globais</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                    <div class="row g-1 mb-md-1">


                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="latitude">Latitude</label>
				                    <input type="number" class="form-control" name="latitude" id="latitude">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="longitude">Longitude</label>
				                    <input type="number" class="form-control" name="longitude" id="longitude">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="nome">Nome</label>
				                    <input type="text" class="form-control" name="nome" id="nome">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="corborda">Cor da borda</label>
				                    <input type="color" class="form-control" name="corborda" id="corborda">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="corfundo">Cor de fundo</label>
				                    <input type="color" class="form-control" name="corfundo" id="corfundo">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="opacidade">Opacidade</label>
				                    <input type="number" class="form-control" name="opacidade" id="opacidade" value="0.5">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="raio">Raio</label> (metros)
				                    <input type="number" class="form-control" name="raio" id="raio">
                        </div>
                        <div class="col-xl-10 col-md-10 col-10">
                            <label class="form-label" for="descricao">Descrição</label>
				                    <input type="text" class="form-control" name="descricao" id="descricao">
                        </div>

                        <button type="submit" class="btn btn-primary" id="button-addon2">Inserir</button>
                    </div>

                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Bordered table start -->
<div class="row" id="table-bordered">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Focos</h4>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nome</th>
                            <th>Cor Borda</th>
                            <th>Cor Fundo</th>
                            <th>Opacidade</th>
                            <th>Raio</th>
                            <th>Ativo</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>

<?php
  $primeira_coord = true;
  $primeira_lat = $cfg_latitude;
  $primeira_lon = $cfg_longitude;
  $matriz = "";
  $rs = $con->prepare("SELECT * FROM maps_tb_focos WHERE id = ? AND ibge = ?");
  $rs->bindParam(1,$_SESSION['login']);
  $rs->bindParam(2,$_SESSION['ibge']);
  if($rs->execute()){
    if($rs->rowCount() > 0){
      while($row = $rs->fetch(PDO::FETCH_OBJ)){


				$bt_ac = "Ativar";
				$status = "<span class=\"badge rounded-pill badge-light-danger me-1\">inativo</span>";
				$status_ac = 'a';
				if ($row->ativo == 1){
					$status = "<span class=\"badge rounded-pill badge-light-success me-1\">ativo</span>";
					$bt_ac = "Inativar";
					$status_ac = 'i';
				}
				$btacao0 = "
					<div class=\"dropdown\">
						<button type=\"button\" class=\"btn btn-sm dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
							<i data-feather=\"more-vertical\"></i>
						</button>
						<div class=\"dropdown-menu\">
							<a class=\"dropdown-item\" href=\"#\" onclick=\"opModal('#myModal','mod/maps/frm_ed_foco.php?idg=".$row->idg."');\">
								<i data-feather=\"edit-2\" class=\"me-50\"></i>
								<span>Editar</span>
							</a>
							<a class=\"dropdown-item\" href=\"#\" onclick=\"SlickLoader.enable();$('.content-body').load('mod/maps/frm_ac_foco.php?ac=e&idg=".$row->idg."');\">
								<i data-feather=\"trash\" class=\"me-50\"></i>
								<span>Excluir</span>
							</a>
							<a class=\"dropdown-item\" href=\"#\" onclick=\"SlickLoader.enable();$('.content-body').load('mod/maps/frm_ac_foco.php?ac=".$status_ac."&idg=".$row->idg."');\">
								<i data-feather=\"x-circle\" class=\"me-50\"></i>
								<span>".$bt_ac."</span>
							</a>
						</div>
					</div>
				";
				echo "
					<tr>
						<td>".$row->idg."</td>
						<td>".$row->nome."</td>
						<td><b style=\"color:".$row->cor_borda."\">".$row->cor_borda."</b></td>
						<td><b style=\"color:".$row->cor_fundo."\">".$row->cor_fundo."</b></td>
						<td>".$row->opacidade."</td>
            <td>".$row->raio." m</td>
						<td>".$status."</td>
						<td>".$btacao0."</td>
					</tr>
				";
        if ($row->ativo == 1){
          $matriz .= "[".$row->latitude.",".$row->longitude.",'".$row->nome."',".$row->idg.",'".$row->icone."','".$row->cor_borda."','".$row->cor_fundo."',".$row->opacidade.",".$row->raio.",'".$row->descricao."'],";
        }
        if ($primeira_coord){
          $primeira_coord = false;
          $primeira_lat = $row->latitude;
          $primeira_lon = $row->longitude;
        }
      }
    }
  }
?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Bordered table end -->

<!-- Modal -->
<div class="modal fade text-start" id="myModal" data-bs-backdrop="static" data-bs-keyboard="false" role="dialog" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">Detalhes</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" onclick="SlickLoader.enable();$('.content-body').load('mod/maps/focos.php');">Fechar</button>
      </div>
    </div>
  </div>
</div>


<script src="mod/maps/leaflet/leaflet.js"></script>
<script>

SlickLoader.disable();

function opModal(idModal, url){
    $(idModal + ' .modal-body').load(url,function(e){
    	$(idModal).modal('show');
    });
}

$(function () {
  const vLatitude = <?php echo $primeira_lat;?>;
  const vLongitude = <?php echo $primeira_lon;?>;
  const vZoom = <?php echo $cfg_zoom;?>;

  let circulos = [
    <?php echo $matriz;?>
  ];

  /*
  let circulos = [
    [
      -26.749405,
      -49.179742,
      'X', 
      23423, 
      'casa1.png',
      'green',
      '#58D68D',
      0.5,
      300,
      '<b>  Soares</b><br>Rua Vale do Selke Pequeno, 830'
    ],
    [
      -26.730422,
      -49.169921,
      'Y', 
      7899, 
      'casa2.png',
      'red',
      '#f03',
      0.5,
      300,
      '<b>Gabriela Vieira Soares</b><br>Rua Vale do Selke Grande, 1578 - Apto 123 Bloco B'
    ],
  ];
  */

  const mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>';
  const mbUrl = 'https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
  const mbAttrOsm = '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>';
  const mbUrlOsm = 'https://tile.openstreetmap.org/{z}/{x}/{y}.png';
	const mbUrlCarto = 'https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png';
	const mbCarto = '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="https://carto.com/attribution">CARTO</a>';

	const positron = L.tileLayer(mbUrlCarto, {attribution: mbCarto});
  const streets = L.tileLayer(mbUrl, {id: 'mapbox/streets-v11', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
  const satellite = L.tileLayer(mbUrl, {id: 'mapbox/satellite-v9', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
  const osm = L.tileLayer(mbUrlOsm, {maxZoom: 19, attribution: mbAttrOsm});

  const LeafIcon = L.Icon.extend({
    options: {
      iconSize:     [24, 24],
      iconAnchor:   [22, 94],
      popupAnchor:  [-3, -76]
    }
  });
  const overlays = {};
  let lays = [];
  lays[0] = <?php echo $mapa_abertura;?>;

  if (typeof circulos !== 'undefined') {
    let circle = [];
    var index_layc = lays.length - 1;
    for(var c = 0; c < circulos.length; c++) {
      circle[c] = L.circle([circulos[c][0], circulos[c][1]], {
        color: circulos[c][5],
        fillColor: circulos[c][6],
        fillOpacity: circulos[c][7],
        radius: circulos[c][8]
      }).bindPopup(circulos[c][9] + '<br><a href="https://maps.google.com/?q=' + circulos[c][0] + ',' + circulos[c][1] + '" target="_blank">Mapa</a><br>Epicentro: '+circulos[c][0] + ', ' + circulos[c][1] + '<br>Raio: ' + circulos[c][8] + 'm');
      overlays['Foco: ' + circulos[c][2]] = circle[c];
      index_layc = index_layc + 1;
      lays[index_layc] = circle[c];
    }
  }

  const baseLayers = {
    'OpenStreetMap': osm,
    'Ruas': streets,
    'Satelite': satellite,
		'Mapa': positron
  };
  const map = L.map('mapf', {
    center: [vLatitude, vLongitude],
    zoom: vZoom,
    layers: lays
  });
  const layerControl = L.control.layers(baseLayers, overlays).addTo(map);

	const popup = L.popup();
	function onMapClick(e) {
    const ta1 = e.latlng.toString().split("(");
    const ta2 = ta1[1].split(",");
    const tLatitude = ta2[0].trim();
    const tLongitude = ta2[1].substring(0,ta2[1].length-1).trim();
		popup
			.setLatLng(e.latlng)
			.setContent('As coordenadas aqui são: ' + tLatitude + ', ' + tLongitude + '<br><a href="https://maps.google.com/?q=' + tLatitude + ',' + tLongitude + '" target="_blank">Mapa</a>')
			.openOn(map);
	}
	map.on('click', onMapClick);

  $('#frm').validate({
    submitHandler: function (form) {

        $.post('mod/maps/gv_foco.php', $('#frm').serialize(), function (data, textStatus) {
          if (data == 'Ok'){ // data.substring(0,2)
            swal.fire('Ok!','Gravado com sucesso!','success');
            SlickLoader.enable();
            $('.content-body').load('mod/maps/focos.php');
          } else {
            swal.fire('erro!',data,'error');
          }
        });
    },
    rules: {
        latitude: {
          required: true,
          number:true
        },
    },
    messages: {
        latitude: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
    }
  });

	if (feather) {
      feather.replace({
          width: 14,
          height: 14
      });
  }

});
</script>