<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$klink = isset($_GET["klink"]) ? trim($_GET["klink"]) : '';

$masc = '';

$rs = $con->prepare("SELECT * FROM maps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$masc = $row->masc;
		}
	}
}

$matb = '';
$nome = '';
$cor_borda = '';
$cor_fundo = '';
$opacidade = 0;
$ativo = 0;

if (strlen($klink) > 1){
    $rs = $con->prepare("SELECT * FROM maps_tb_areas WHERE id = ? AND ibge = ? AND klink = ? LIMIT 1");
    $rs->bindParam(1,$_SESSION['login']);
    $rs->bindParam(2,$_SESSION['ibge']);
    $rs->bindParam(3,$klink);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $matb = $row->ma;
                $nome = $row->nome;
                $cor_borda = $row->cor_borda;
                $cor_fundo = $row->cor_fundo;
                $opacidade = $row->opacidade;
                $ativo = $row->ativo;
            }
        }
    }
}

$invertido = false;
$mascat = array();
if (strlen($masc) > 0){
    if (strlen($masc) == 1 && $masc == '0'){
        $mascat[] = "todos";
    } else {
        if (strlen($masc) >= 2){
            if (substr($masc,0,1) == '-'){
                $invertido = true;
                $masc = substr($masc,1);
            }
            $pos = strpos($masc,';');
            if ($pos === false) {
                if (strlen($masc) == 2){
                    $mascat[] = $masc;
                }
            } else {
                $mascat = explode(';',$masc);
            }
        }
    }
} else {
	$mascat[] = "todos";
}

?>

<form class="dt_adv_search" name="frm-area" id="frm-area" method="POST">
    <input type="hidden" id="klink" name="klink" value="<?php echo $klink;?>">
    <label>Nome: </label>
    <div class="mb-1">
        <input type="text" placeholder="Nome da área" name="nome" id="nome" class="form-control" value="<?php echo $nome;?>" />
    </div>
    <label>Microárea: </label>
    <div class="mb-1">
        <select class="form-select" name="matb" id="matb">
			<option value="0">Escolha uma Microárea</option>
			<?php
				$ct_equipe = '';
				$domi = $cdb->query($sql_ma);
				if($domi->execute()){
					if($domi->rowCount() > 0){
						while($rowsd = $domi->fetch(PDO::FETCH_OBJ)){
							if ($rowsd->no_equipe != $ct_equipe){
								if (strlen($ct_equipe) > 0){
									echo "</optgroup>";
								}
								$ct_equipe = $rowsd->no_equipe;
								echo "<optgroup label=\"".$rowsd->no_equipe."\">";
							}
							if (in_array("todos", $mascat)) {
								if ($matb == $rowsd->nu_micro_area){
									echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
								} else {
									echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
								}
							} else {
								if ($invertido){
									if (!in_array($rowsd->nu_micro_area, $mascat)) {
										if ($matb == $rowsd->nu_micro_area){
											echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
										} else {
											echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
										}	
									}
								} else {
									if (in_array($rowsd->nu_micro_area, $mascat)) {
										if ($matb == $rowsd->nu_micro_area){
											echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
										} else {
											echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
										}	
									}
								}
							}	
						}
						echo "</optgroup>";
					}
				}
			?>
		</select>
    </div>
    <label>Cor da borda: </label>
    <div class="mb-1">
        <input type="color" name="corborda" id="corborda" class="form-control" value="<?php echo $cor_borda;?>" />
    </div>
    <label>Cor de fundo: </label>
    <div class="mb-1">
        <input type="color" name="corfundo" id="corfundo" class="form-control" value="<?php echo $cor_fundo;?>" />
    </div>
    <label>Opacidade: </label>
    <div class="mb-1">
        <input type="number" name="opacidade" id="opacidade" class="form-control" value="<?php echo $opacidade;?>" />
    </div>
    <label>Situação: </label>
    <div class="mb-1">
        <select class="form-select" name="ativo" id="ativo">
            <?php
                if ($ativo == 1){
                    echo "
                        <option value=\"1\" selected>Ativo</option>
                        <option value=\"0\">Inativo</option>
                    ";
                } else {
                    echo "
                        <option value=\"1\">Ativo</option>
                        <option value=\"0\" selected>Inativo</option>
                    "; 
                }
            ?>
        </select>
    </div>
    <button type="submit" class="btn btn-primary">Gravar</button>
</form>

<script>
$(function () {
  $('#frm-area').validate({
    submitHandler: function (form) {
        $.post('mod/maps/gv_ed_area.php', $('#frm-area').serialize(), function (data, textStatus) {
            if (data == 'Ok'){ // data.substring(0,2)
                swal.fire('Ok!','Gravado com sucesso!','success');
                //$('.content-body').load('mod/maps/mas.php');
            } else {
                swal.fire('erro!',data,'error');
            }
        });
    },
    rules: {
        opacidade: {
          required: true,
          number:true
        },
        nome: {
          required: true
        },
    },
    messages: {
        opacidade: {
          required: "Este campo é necessário",
          number: "Deve ser número"
        },
        nome: {
          required: "Este campo é necessário"
        },
    }
  });
})
</script>