<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$matb = isset($_GET["matb"]) ? trim($_GET["matb"]) : '0';
if ($matb == '0' || $matb == '00' || strlen($matb) <= 0){
	$matb = '';
}

$mostrar = isset($_GET["mostrar"]) ? trim($_GET["mostrar"]) : 0;

$dtif = isset($_GET["dtif"]) ? $_GET["dtif"] : 0;
if ($dtif == 0){
	$dti = fgpa('i');
	$dtf = fgpa('f');
} else {
	if (strlen($dtif) == 23){
		$dti = datanas4(trim(substr($dtif,0,10)));
		$dtf = datanas4(trim(substr($dtif,13,10)));	
	} else {
		$dti = fgpa('i');
		$dtf = fgpa('f');
	}

}
$dtif = datanas6($dti).' - '.datanas6($dtf);

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$cfg_largura = $cfgeral_largura;
$cfg_altura = $cfgeral_altura;
$cfg_latitude = $cfgeral_latitude;
$cfg_longitude = $cfgeral_longitude;
$cfg_zoom = $cfgeral_zoom;
$cfg_tbtmp = $cfgeral_tbtmp;
$cfg_coorintma = $cfgeral_coorintma;
$cfg_coorintvis = $cfgeral_coorintvis;
$cfg_metodo = $cfgeral_metodo;
$cfg_key_api_bing = $cfgeral_key_api_bing;
$masc = '';

$rs = $con->prepare("SELECT * FROM maps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$cfg_largura = $row->largura;
			$cfg_altura = $row->altura;
			$cfg_latitude = $row->latitude;
			$cfg_longitude = $row->longitude;
			$cfg_zoom = $row->zoom;
			$cfg_tbtmp = $row->tbtmp;
			$cfg_coorintma = $row->coorintma;
			$cfg_coorintvis = $row->coorintvis;
			$masc = $row->masc;
			$cfg_metodo = $row->metodo;
			$cfg_key_api_bing = $row->key_api_bing;
		}
	}
}

if ($cfg_metodo == 0 && strlen($cfg_key_api_bing) <= 0){
	$cfg_key_api_bing = $cfgeral_key_api_bing2;
}

$prim_lat = $cfg_latitude;
$prim_lon = $cfg_longitude;
$prim_coord = true;

$invertido = false;
$mascat = array();
if (strlen($masc) > 0){
    if (strlen($masc) == 1 && $masc == '0'){
        $mascat[] = "todos";
    } else {
        if (strlen($masc) >= 2){
            if (substr($masc,0,1) == '-'){
                $invertido = true;
                $masc = substr($masc,1);
            }
            $pos = strpos($masc,';');
            if ($pos === false) {
                if (strlen($masc) == 2){
                    $mascat[] = $masc;
                }
            } else {
                $mascat = explode(';',$masc);
            }
        }
    }
} else {
	$mascat[] = "todos";
}



$matriz_casas = "";
$casas_ma = array();
$casas_ma_conta = 0;

$matriz_visitas = "";
$casas_vis = array();
$casas_vis_conta = 0;

$casas_vis_erro = array();
$casas_vis_erro_conta = 0;

if (strlen($matb) > 0){
	if ($mostrar == 0 || $mostrar == 1){
		if ($cfg_tbtmp == 0){
			include($path_local_raiz.'class/_casas.class.php');
			$cas = new Casas($cdb, $matb);
			$cas->todos();
			if ($cas->totalEncontrado > 0){
				$matriz_casas = "['Microárea: ".$matb."', '".$matb."', '".$cfg_ma_icone."','".$cfg_ma_cor_borda."','".$cfg_ma_cor_fundo."',".$cfg_ma_opacidade.",[";
				$conta_casas = 0;
				for ($i=0;$i<count($cas->casas);$i++){
					$lat = $cas->casas[$i]['nu_latitude'];
					$lon = $cas->casas[$i]['nu_longitude'];
					$lat = ($lat == 0) ? '' : $lat;
					$lon = ($lon == 0) ? '' : $lon;
					$mapa_id_area = '';
					$mapa_id_osm = '';
					$mapa_classe = '';
					$mapa_tipo = '';
					$mapa_completo = '';
					$mapa_area = '';
		
					if (strlen($lat) > 0 && strlen($lon) > 0){
						if ($prim_coord){
							$prim_lat = $lat;
							$prim_lon = $lon;
							$prim_coord = false;
						}
					}

					$casa_endereco = $cas->casas[$i]['no_tipo_logradouro'].' '.$cas->casas[$i]['no_logradouro'].' '.$cas->casas[$i]['nu_domicilio'].' '.$cas->casas[$i]['no_municipio'].' '.$cas->casas[$i]['sg_uf'];
					$casa_endereco = tirap($casa_endereco);
					$casa_endereco = strtolower($casa_endereco);
					$pg_cor_internet = false;
					if ((strlen($lat) <= 0 || strlen($lon) <= 0) && $_SESSION['internet'] && ($cfg_coorintma == 1)){
						if ($cfg_metodo == 0 && strlen($cfg_key_api_bing) > 10){
							$mt0_endereco = $cas->casas[$i]['sg_uf']."/".$cas->casas[$i]['no_municipio']."/".$cas->casas[$i]['nu_domicilio']." ".$cas->casas[$i]['no_logradouro'];
							$mt0_endereco = urlencode($mt0_endereco);
							//$mt0_endereco = str_ireplace(" ","%20",$mt0_endereco);
							$mt0_url = "http://dev.virtualearth.net/REST/v1/Locations/BR/".$mt0_endereco."?output=xml&key=".$cfg_key_api_bing;
							
							$mt0_response = simplexml_load_file($mt0_url);
							//$mt0_output = file_get_contents($mt0_url);
							//$mt0_response = new SimpleXMLElement($mt0_output);

							$pg_cor_internet = true;
							$lat = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Point->Latitude;
							$lon = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Point->Longitude;
							$idsmaps = explode("|",$mt0_response->TraceId);
							$mapa_id_area = $idsmaps[0];
							$mapa_id_osm = $idsmaps[1];
							$mapa_completo = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Name;
							$mapa_area = $mt0_response->ResourceSets->ResourceSet->Resources->Location->BoundingBox->SouthLatitude.','.$mt0_response->ResourceSets->ResourceSet->Resources->Location->BoundingBox->WestLongitude.','.$mt0_response->ResourceSets->ResourceSet->Resources->Location->BoundingBox->NorthLatitude.','.$mt0_response->ResourceSets->ResourceSet->Resources->Location->BoundingBox->EastLongitude;

							/*
								http://dev.virtualearth.net/REST/v1/Locations/countryRegion/adminDistrict/postalCode/locality/addressLine?key=yourBingMapsKey
								https://stackoverflow.com/questions/51710240/bing-maps-rest-api-using-php

								$ch = curl_init();
								// Set query data here with the URL
								curl_setopt($ch, CURLOPT_URL, $findURL); 
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
								curl_setopt($ch, CURLOPT_TIMEOUT, 3);
								$content = trim(curl_exec($ch));
								curl_close($ch);
								$response = new SimpleXMLElement($content);
	
								rua e numero
								$mt0_response->ResourceSets->ResourceSet->Resources->Location->Address->AddressLine
								estado
								$mt0_response->ResourceSets->ResourceSet->Resources->Location->Address->AdminDistrict
								pais
								$mt0_response->ResourceSets->ResourceSet->Resources->Location->Address->CountryRegion
								endereco completo 2
								$mt0_response->ResourceSets->ResourceSet->Resources->Location->Address->FormattedAddress
								cidade
								$mt0_response->ResourceSets->ResourceSet->Resources->Location->Address->Locality
								cep
								$mt0_response->ResourceSets->ResourceSet->Resources->Location->Address->PostalCode
							*/
						} else {
							$name_address = urlencode($casa_endereco);
							$baseUrl = 'http://nominatim.openstreetmap.org/search?format=json&q='.$name_address;
							$opts = array(
								'http' => array(
									'header' => "User-Agent:MyAgent/1.0\r\n"
								)
							); 
							$context = stream_context_create($opts);
							$data = @file_get_contents($baseUrl, false, $context);
							if($data === FALSE) { 
								// nao retornou nada
							} else {
								$json = json_decode($data);
			
								$trouxe_conteudo = true;
								if (empty($json)) {
									$trouxe_conteudo = false;
								}
			
								if ($trouxe_conteudo){
									$pg_cor_internet = true;
									$lat = $json[0]->lat;
									$lon = $json[0]->lon;
									$mapa_id_area = $json[0]->place_id;
									$mapa_id_osm = $json[0]->osm_id;
									$mapa_classe = $json[0]->class;
									$mapa_tipo = $json[0]->type;
									$mapa_completo = $json[0]->display_name;
									$mapa_area = $json[0]->boundingbox;
								}
							}
						}
					}

					$ctrl_dup = $cas->casas[$i]['nome'].$cas->casas[$i]['mae'].$cas->casas[$i]['dt_nascimento'].$cas->casas[$i]['no_logradouro'];
					if (false !== $key = array_search($ctrl_dup, array_column($casas_ma, 'ctrl'))) {
						// encontrou duplicado
					} else {
						$casas_ma[$casas_ma_conta]['lat'] = $lat;
						$casas_ma[$casas_ma_conta]['lon'] = $lon;
						$casas_ma[$casas_ma_conta]['uf'] = $cas->casas[$i]['sg_uf'];
						$casas_ma[$casas_ma_conta]['municipio'] = $cas->casas[$i]['no_municipio'];
						$casas_ma[$casas_ma_conta]['marea'] = $cas->casas[$i]['nu_micro_area'];
						$casas_ma[$casas_ma_conta]['bairro'] = $cas->casas[$i]['no_bairro'];
						$casas_ma[$casas_ma_conta]['logradouro'] = $cas->casas[$i]['no_logradouro'];
						$casas_ma[$casas_ma_conta]['numero'] = $cas->casas[$i]['nu_domicilio'];
						$casas_ma[$casas_ma_conta]['pginter'] = $pg_cor_internet;
						$casas_ma[$casas_ma_conta]['complemento'] = $cas->casas[$i]['ds_complemento'];
						$casas_ma[$casas_ma_conta]['responsavel'] = $cas->casas[$i]['nome'];
						$casas_ma[$casas_ma_conta]['mae'] = $cas->casas[$i]['mae'];
						$casas_ma[$casas_ma_conta]['dtnas'] = $cas->casas[$i]['dt_nascimento'];
						$casas_ma[$casas_ma_conta]['endereco'] = $casa_endereco;
						$casas_ma[$casas_ma_conta]['ctrl'] = $ctrl_dup;
						$casas_ma_conta++;

						if (strlen($lat) > 0 && strlen($lon) > 0){
							$matriz_casas .= "[".$lat.", ".$lon.", '<b>".$cas->casas[$i]['nome']."</b><br>".$cas->casas[$i]['no_tipo_logradouro']." ".$cas->casas[$i]['no_logradouro'].", ".$cas->casas[$i]['nu_domicilio']."<br>".$cas->casas[$i]['ds_cep']." ".$cas->casas[$i]['no_bairro']." (".$cas->casas[$i]['ds_complemento'].")'],";
							$conta_casas++;
						}
					}
				}
				$matriz_casas .= "]],";
				if ($conta_casas <= 0){
					$matriz_casas = "";
				}
			}
		
		} else {
			$domi = $con->prepare("SELECT * FROM maps_tb_tmp_casas WHERE id = ? AND ibge = ? AND nu_micro_area = ?");
			$domi->bindParam(1,$_SESSION['login']);
			$domi->bindParam(2,$_SESSION['ibge']);
			$domi->bindParam(3,$matb);
			if($domi->execute()){
				if($domi->rowCount() > 0){
					$matriz_casas = "['Microárea: ".$matb."', '".$matb."', '".$cfg_ma_icone."','".$cfg_ma_cor_borda."','".$cfg_ma_cor_fundo."',".$cfg_ma_opacidade.",[";
					$conta_casas = 0;
					while($rowsd = $domi->fetch(PDO::FETCH_OBJ)){
						$lat = $rowsd->nu_latitude;
						$lon = $rowsd->nu_longitude;
						$lat = ($lat == 0) ? '' : $lat;
						$lon = ($lon == 0) ? '' : $lon;

						if (strlen($lat) > 0 && strlen($lon) > 0){
							if ($prim_coord){
								$prim_lat = $lat;
								$prim_lon = $lon;
								$prim_coord = false;
							}
						}

						$ctrl_dup = $rowsd->nome.$rowsd->mae.$rowsd->dt_nascimento.$rowsd->no_logradouro;
						if (false !== $key = array_search($ctrl_dup, array_column($casas_ma, 'ctrl'))) {
							// encontrou duplicado
						} else {

							$casa_endereco = $rowsd->no_tipo_logradouro.' '.$rowsd->no_logradouro.' '.$rowsd->nu_domicilio.' '.$rowsd->no_municipio.' '.$rowsd->sg_uf;
							$casa_endereco = tirap($casa_endereco);
							$casa_endereco = strtolower($casa_endereco);

							$casas_ma[$casas_ma_conta]['lat'] = $lat;
							$casas_ma[$casas_ma_conta]['lon'] = $lon;
							$casas_ma[$casas_ma_conta]['uf'] = $rowsd->sg_uf;
							$casas_ma[$casas_ma_conta]['municipio'] = $rowsd->no_municipio;
							$casas_ma[$casas_ma_conta]['marea'] = $rowsd->nu_micro_area;
							$casas_ma[$casas_ma_conta]['bairro'] = $rowsd->no_bairro;
							$casas_ma[$casas_ma_conta]['logradouro'] = $rowsd->no_logradouro;
							$casas_ma[$casas_ma_conta]['numero'] = $rowsd->nu_domicilio;
							$casas_ma[$casas_ma_conta]['pginter'] = $rowsd->pg_internet;
							$casas_ma[$casas_ma_conta]['complemento'] = $rowsd->ds_complemento;
							$casas_ma[$casas_ma_conta]['responsavel'] = $rowsd->nome;
							$casas_ma[$casas_ma_conta]['mae'] = $rowsd->mae;
							$casas_ma[$casas_ma_conta]['dtnas'] = $rowsd->dt_nascimento;
							$casas_ma[$casas_ma_conta]['endereco'] = $casa_endereco;
							$casas_ma[$casas_ma_conta]['ctrl'] = $ctrl_dup;
							$casas_ma_conta++;

							if (strlen($lat) > 0 && strlen($lon) > 0){
								$matriz_casas .= "[".$lat.", ".$lon.", '<b>".$rowsd->nome."</b><br>".$rowsd->no_tipo_logradouro." ".$rowsd->no_logradouro.", ".$rowsd->nu_domicilio."<br>".$rowsd->ds_cep." ".$rowsd->no_bairro." (".$rowsd->ds_complemento.")'],";
								$conta_casas++;
							}
						}
					}
					$matriz_casas .= "]],";
					if ($conta_casas <= 0){
						$matriz_casas = "";
					}
				}
			}
		}
	}
	if ($mostrar == 0 || $mostrar == 2){
		include($path_local_raiz.'class/_visitas.class.php');
		$cbos = array('515105','515140');
		$vis = new VisitasMA($cdb, $matb, $dti, $dtf, $cbos);
		$vis->todos();
		
		if ($vis->totalEncontrado > 0){
			$matriz_visitas = "['Visitas: ".$matb."', '".$matb."', '".$cfg_vis_icone."','".$cfg_vis_cor_borda."','".$cfg_vis_cor_fundo."',".$cfg_vis_opacidade.",[";
			$conta_visitas = 0;
			for ($i=0;$i<count($vis->visitas);$i++){
				$lat = $vis->visitas[$i]['lati'];
				$lon = $vis->visitas[$i]['long'];
				$lat = ($lat == 0) ? '' : $lat;
				$lon = ($lon == 0) ? '' : $lon;
				$mapa_id_area = '';
				$mapa_id_osm = '';
				$mapa_classe = '';
				$mapa_tipo = '';
				$mapa_completo = '';
				$mapa_area = '';
				if (strlen($lat) <= 0){
					$lat = $vis->visitas[$i]['lati_end'];
				}
				if (strlen($lon) <= 0){
					$lon = $vis->visitas[$i]['long_end'];
				}
				$lat = ($lat == 0) ? '' : $lat;
				$lon = ($lon == 0) ? '' : $lon;
				
				if (strlen($lat) > 0 && strlen($lon) > 0){
					if ($prim_coord){
						$prim_lat = $lat;
						$prim_lon = $lon;
						$prim_coord = false;
					}
				}

				$casa_endereco = $vis->visitas[$i]['tipoLogradouro'].' '.$vis->visitas[$i]['logradouro'].' '.$vis->visitas[$i]['numero'].' '.$vis->visitas[$i]['municipio'].' '.$vis->visitas[$i]['uf'];
		
				$casa_endereco = tirap($casa_endereco);
				$casa_endereco = strtolower($casa_endereco);
				$pg_cor_internet = false;
				if ((strlen($lat) <= 0 || strlen($lon) <= 0) && $_SESSION['internet'] && ($cfg_coorintvis == 1)){
					$name_address = urlencode($casa_endereco);
					$baseUrl = 'http://nominatim.openstreetmap.org/search?format=json&q='.$name_address;
					$opts = array(
						'http' => array(
							'header' => "User-Agent:MyAgent/1.0\r\n"
						)
					); 
					$context = stream_context_create($opts);
					$data = @file_get_contents($baseUrl, false, $context);
					if($data === FALSE) { 
						// nao retornou nada
					} else {
						$json = json_decode($data);
		
						$trouxe_conteudo = true;
						if (empty($json)) {
							$trouxe_conteudo = false;
						}
		
						if ($trouxe_conteudo){
							$pg_cor_internet = true;
							$lat = $json[0]->lat;
							$lon = $json[0]->lon;
							$mapa_id_area = $json[0]->place_id;
							$mapa_id_osm = $json[0]->osm_id;
							$mapa_classe = $json[0]->class;
							$mapa_tipo = $json[0]->type;
							$mapa_completo = $json[0]->display_name;
							$mapa_area = $json[0]->boundingbox;
						}
					}
				}
				
				$ctrl_dup = $vis->visitas[$i]['dtVisita'].$vis->visitas[$i]['nome'].$vis->visitas[$i]['desfVisita'].$vis->visitas[$i]['dtNascimento'];
				if (strlen(trim($vis->visitas[$i]['logradouro'])) > 0){
					if (false !== $key = array_search($ctrl_dup, array_column($casas_vis, 'ctrl'))) {
						// encontrou duplicado
					} else {
						$casas_vis[$casas_vis_conta]['lat'] = $lat;
						$casas_vis[$casas_vis_conta]['lon'] = $lon;
						$casas_vis[$casas_vis_conta]['data'] = $vis->visitas[$i]['dtVisita'];
						$casas_vis[$casas_vis_conta]['cns'] = $vis->visitas[$i]['cns'];
						$casas_vis[$casas_vis_conta]['cidadao'] = $vis->visitas[$i]['cidadao'];
						$casas_vis[$casas_vis_conta]['desfVisita'] = $vis->visitas[$i]['desfVisita'];
						$casas_vis[$casas_vis_conta]['pginter'] = $pg_cor_internet;
						$casas_vis[$casas_vis_conta]['responsavel'] = $vis->visitas[$i]['nome'];
						$casas_vis[$casas_vis_conta]['marea'] = $matb;
						$casas_vis[$casas_vis_conta]['uf'] = $vis->visitas[$i]['uf'];
						$casas_vis[$casas_vis_conta]['municipio'] = $vis->visitas[$i]['municipio'];
						$casas_vis[$casas_vis_conta]['bairro'] = $vis->visitas[$i]['bairro'];
						$casas_vis[$casas_vis_conta]['logradouro'] = $vis->visitas[$i]['logradouro'];
						$casas_vis[$casas_vis_conta]['numero'] = $vis->visitas[$i]['numero'];
						$casas_vis[$casas_vis_conta]['complemento'] = $vis->visitas[$i]['complemento'];
						$casas_vis[$casas_vis_conta]['mae'] = $vis->visitas[$i]['mae'];
						$casas_vis[$casas_vis_conta]['dtnas'] = $vis->visitas[$i]['dtNascimento'];
						$casas_vis[$casas_vis_conta]['endereco'] = $casa_endereco;
						$casas_vis[$casas_vis_conta]['ctrl'] = $vis->visitas[$i]['dtVisita'].$vis->visitas[$i]['nome'].$vis->visitas[$i]['desfVisita'].$vis->visitas[$i]['dtNascimento'];
						$casas_vis_conta++;
				
						if (strlen($lat) > 0 && strlen($lon) > 0){
							$matriz_visitas .= "[".$lat.", ".$lon.", '<b>".$vis->visitas[$i]['nome']."</b><br>Data da visita: ".datanas6($vis->visitas[$i]['dtVisita'])."<br>Desfecho: ".$vis->visitas[$i]['desfVisita']."<br>".$vis->visitas[$i]['tipoLogradouro']." ".$vis->visitas[$i]['logradouro'].", ".$vis->visitas[$i]['numero']." (".$vis->visitas[$i]['complemento'].")'],";
							$conta_visitas++;
						}
					}
				} else {
					if (false !== $key = array_search($ctrl_dup, array_column($casas_vis_erro, 'ctrl'))) {
						// encontrou duplicado
					} else {
						$casas_vis_erro[$casas_vis_erro_conta]['lat'] = $lat;
						$casas_vis_erro[$casas_vis_erro_conta]['lon'] = $lon;
						$casas_vis_erro[$casas_vis_erro_conta]['data'] = $vis->visitas[$i]['dtVisita'];
						$casas_vis_erro[$casas_vis_erro_conta]['cns'] = $vis->visitas[$i]['cns'];
						$casas_vis_erro[$casas_vis_erro_conta]['cidadao'] = $vis->visitas[$i]['cidadao'];
						$casas_vis_erro[$casas_vis_erro_conta]['desfVisita'] = $vis->visitas[$i]['desfVisita'];
						$casas_vis_erro[$casas_vis_erro_conta]['responsavel'] = $vis->visitas[$i]['nome'];
						$casas_vis_erro[$casas_vis_erro_conta]['marea'] = $matb;
						$casas_vis_erro[$casas_vis_erro_conta]['mae'] = $vis->visitas[$i]['mae'];
						$casas_vis_erro[$casas_vis_erro_conta]['dtnas'] = $vis->visitas[$i]['dtNascimento'];
						$casas_vis_erro[$casas_vis_erro_conta]['endereco'] = $casa_endereco;
						$casas_vis_erro[$casas_vis_erro_conta]['ctrl'] = $vis->visitas[$i]['dtVisita'].$vis->visitas[$i]['nome'].$vis->visitas[$i]['desfVisita'].$vis->visitas[$i]['dtNascimento'];
						$casas_vis_erro_conta++;
					}
				}
			}
			$matriz_visitas .= "]],";
			if ($conta_visitas <= 0){
				$matriz_visitas = "";
			}
		}	
	}
}

$matriz_area = "";
if (strlen($matb) > 0){
	$rs = $con->prepare("SELECT * FROM maps_tb_areas WHERE id = ? AND ibge = ? AND ma = ? AND ativo = 1");
	$rs->bindParam(1,$_SESSION['login']);
	$rs->bindParam(2,$_SESSION['ibge']);
	$rs->bindParam(3,$matb);
	if($rs->execute()){
		if($rs->rowCount() > 0){
			while($row = $rs->fetch(PDO::FETCH_OBJ)){
				$matriz_area .= "['".$row->nome."',".$row->idg.",'".$row->icone."','".$row->cor_borda."','".$row->cor_fundo."',".$row->opacidade.",'".$row->descricao."',[";
				$rsp = $con->prepare("SELECT * FROM maps_tb_areas_pontos WHERE id = ? AND ibge = ? AND klink = ?");
				$rsp->bindParam(1,$_SESSION['login']);
				$rsp->bindParam(2,$_SESSION['ibge']);
				$rsp->bindParam(3,$row->klink);
				if($rsp->execute()){
					if($rsp->rowCount() > 0){
						while($rowp = $rsp->fetch(PDO::FETCH_OBJ)){
							$matriz_area .= "[".$rowp->latitude.",".$rowp->longitude.",'".$rowp->descricao."'],";
						}
					}
				}
				$matriz_area .= "]],";
			}
		}
	}
}

?>
<link rel="stylesheet" type="text/css" href="mod/maps/leaflet/leaflet.css">

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Visitas</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Escolha uma Microárea para ver o mapa</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">




					<div class="row g-1 mb-md-1">
						<div class="col-md-2">
							<label class="form-label"><b>Microárea</b></label>
							<select class="form-select" aria-label="Default select example" name="matb" id="matb">
								<option value="0">Escolha uma Microárea</option>
								<?php
									$ct_equipe = '';
									$domi = $cdb->query($sql_ma);
									if($domi->execute()){
										if($domi->rowCount() > 0){
											while($rowsd = $domi->fetch(PDO::FETCH_OBJ)){
												if ($rowsd->no_equipe != $ct_equipe){
													if (strlen($ct_equipe) > 0){
														echo "</optgroup>";
													}
													$ct_equipe = $rowsd->no_equipe;
													echo "<optgroup label=\"".$rowsd->no_equipe."\">";
												}
												if (in_array("todos", $mascat)) {
													if ($matb == $rowsd->nu_micro_area){
														echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
													} else {
														echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
													}
												} else {
													if ($invertido){
														if (!in_array($rowsd->nu_micro_area, $mascat)) {
															if ($matb == $rowsd->nu_micro_area){
																echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															} else {
																echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															}	
														}
													} else {
														if (in_array($rowsd->nu_micro_area, $mascat)) {
															if ($matb == $rowsd->nu_micro_area){
																echo "<option value=\"".$rowsd->nu_micro_area."\" selected>[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															} else {
																echo "<option value=\"".$rowsd->nu_micro_area."\">[".$rowsd->nu_micro_area."] ".$rowsd->no_profissional."</option>";
															}	
														}
													}
												}	
											}
											echo "</optgroup>";
										}
									}
								?>
							</select>
						</div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="dtif">Data de Inicio e Data de Fim das visitas</label>
                                <input type="text" class="form-control float-right" name="dtif" id="dtif" />
                            </div>
                        </div>
						<div class="col-md-2">
							<label class="form-label"><b>Mostrar</b></label>
							<select class="form-select" aria-label="Default select example" name="mostrar" id="mostrar">
								<?php
								if ($mostrar == 0){
									echo "
										<option value=\"0\" selected>Ambos</option>
										<option value=\"1\">Apenas Microárea (ignora data)</option>
										<option value=\"2\">Apenas Visitas</option>
									";
								} elseif ($mostrar == 1){
									echo "
										<option value=\"0\">Ambos</option>
										<option value=\"1\" selected>Apenas Microárea (ignora data)</option>
										<option value=\"2\">Apenas Visitas</option>
									";
								} else {
									echo "
										<option value=\"0\">Ambos</option>
										<option value=\"1\">Apenas Microárea (ignora data)</option>
										<option value=\"2\" selected>Apenas Visitas</option>
									";
								}
								?>

							</select>
						</div>
						<button class="btn btn-warning col-md-4" type="button" id="tbtmpbt">Ver mapa</button>
					</div>




                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Mapa</h4>
                </div>
                <div class="card-body mt-2">

                  <div id='mapv' style="width: <?php echo $cfg_largura;?>; height: <?php echo $cfg_altura;?>;"></div>

                </div>
            </div>
        </div>
    </div>
</section>
<div id="resendereco" name="resendereco"></div>
<?php
if ($mostrar == 0 || $mostrar == 1){
?>
                <!-- Bordered table start -->
                <div class="row" id="table-bordered">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Imóveis da Microárea <?php echo $matb;?></h4>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Bairro</th>
                                            <th>Logradouro</th>
                                            <th>Número</th>
                                            <th>Complemento</th>
                                            <th>Responsável</th>
											<th>Coordenadas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
									<?php
										$ct_bairro = '';
										$ct_logradouro = '';
										for($i=0;$i<count($casas_ma);$i++){
											if ($ct_bairro != $casas_ma[$i]['bairro']){
												echo "
												<tr>
													<td><span class=\"fw-bold\">".$casas_ma[$i]['bairro']."</span></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
												</tr>
												";
												$ct_bairro = $casas_ma[$i]['bairro'];
											}
											if ($ct_logradouro != $casas_ma[$i]['logradouro']){
												echo "
												<tr>
													<td></td>
													<td><span class=\"fw-bold\">".$casas_ma[$i]['logradouro']."</span></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
												</tr>
												";
												$ct_logradouro = $casas_ma[$i]['logradouro'];
											}
											$td_coord = "<td><span class=\"badge rounded-pill badge-light-primary me-1\">".$casas_ma[$i]['lat']." ".$casas_ma[$i]['lon']."</span> ".$casas_ma[$i]['pginter']."<br><a href=\"https://maps.google.com/?q=".$casas_ma[$i]['lat'].",".$casas_ma[$i]['lon']."\" target=\"_blank\">Mapa</a></td>";
											if (strlen($casas_ma[$i]['lat']) <= 0 || strlen($casas_ma[$i]['lon']) <= 0){
												//$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><button onclick=\"vercoord('".urlencode($casas_ma[$i]['endereco'])."');\"><img src=\"mod/maps/img/mapa.png\"></button></td>";
												$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><img src=\"mod/maps/img/mapa.png\" onclick=\"vercoord('".urlencode($casas_ma[$i]['endereco'])."');\"></td>";
											}
											echo "
											<tr>
												<td></td>
												<td></td>
												<td>".$casas_ma[$i]['numero']."</td>
												<td>".$casas_ma[$i]['complemento']."</td>
												<td>".$casas_ma[$i]['responsavel']."<br>Mãe: ".$casas_ma[$i]['mae']."<br>Dt nas.: ".datanas2($casas_ma[$i]['dtnas'])."</td>
												".$td_coord."
											</tr>
											";
										}
									?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Bordered table end -->
<?php
}
if ($mostrar == 0 || $mostrar == 2){
?>
                <!-- Bordered table start -->
                <div class="row" id="table-bordered">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Visitas da Microárea <?php echo $matb;?></h4>
                            </div>
                            <div class="card-body">
                                <p class="card-text">
                                    De <?php echo datanas6($dti);?> até <?php echo datanas6($dtf);?>
                                </p>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
											<th>#</th>
											<th>Data</th>
                                            <th>Bairro</th>
                                            <th>Logradouro</th>
                                            <th>Número</th>
                                            <th>Complemento</th>
                                            <th>Visitado</th>
											<th>Coordenadas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
									<?php
										$ct_data = '';
										$ct_bairro = '';
										$ct_logradouro = '';
										for($i=0;$i<count($casas_vis);$i++){
											
											if ($ct_data != $casas_vis[$i]['data']){
												echo "
												<tr>
													<td></td>
													<td><span class=\"fw-bold\">".datanas6($casas_vis[$i]['data'])."</span></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
												</tr>
												";
												$ct_data = $casas_vis[$i]['data'];
												$ct_bairro = '';
												$ct_logradouro = '';
											}
											/*
											if ($ct_bairro != $casas_vis[$i]['bairro']){
												echo "
												<tr>
													<td></td>
													<td></td>
													<td><span class=\"fw-bold\">".$casas_vis[$i]['bairro']."</span></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
												</tr>
												";
												$ct_bairro = $casas_vis[$i]['bairro'];
												$ct_logradouro = '';
											}
											if ($ct_logradouro != $casas_vis[$i]['logradouro']){
												echo "
												<tr>
													<td></td>
													<td></td>
													<td></td>
													<td><span class=\"fw-bold\">".$casas_vis[$i]['logradouro']."</span></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
												</tr>
												";
												$ct_logradouro = $casas_vis[$i]['logradouro'];
											}
											*/
											$td_coord = "<td><span class=\"badge rounded-pill badge-light-primary me-1\">".$casas_vis[$i]['lat']." ".$casas_vis[$i]['lon']."</span> ".$casas_vis[$i]['pginter']."<br><a href=\"https://maps.google.com/?q=".$casas_vis[$i]['lat'].",".$casas_vis[$i]['lon']."\" target=\"_blank\">Mapa</a></td>";
											if (strlen($casas_vis[$i]['lat']) <= 0 || strlen($casas_vis[$i]['lon']) <= 0){
												$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><img src=\"mod/maps/img/mapa.png\" onclick=\"vercoord('".urlencode($casas_vis[$i]['endereco'])."');\"></td>";
											}
											echo "
											<tr>
												<td>".($i+1)."</td>
												<td></td>
												<td><span class=\"fw-bold\">".$casas_vis[$i]['bairro']."</span></td>
												<td><span class=\"fw-bold\">".$casas_vis[$i]['logradouro']."</span></td>
												<td>".$casas_vis[$i]['numero']."</td>
												<td>".$casas_vis[$i]['complemento']."</td>
												<td>".$casas_vis[$i]['responsavel']."<br>Mãe: ".$casas_vis[$i]['mae']."<br>Dt nas.: ".datanas2($casas_vis[$i]['dtnas'])."</td>
												".$td_coord."
											</tr>
											";
										}
										for($i=0;$i<count($casas_vis_erro);$i++){
											echo "
											<tr>
												<td>".($i+1)."</td>
												<td>".datanas6($casas_vis_erro[$i]['data'])."</td>
												<td>".$casas_vis_erro[$i]['responsavel']."</td>
												<td>".$casas_vis_erro[$i]['mae']."</td>
												<td>".datanas2($casas_vis_erro[$i]['dtnas'])."</td>
												<td>".$casas_vis_erro[$i]['desfVisita']."</td>
												<td>".$casas_vis_erro[$i]['cns']."</td>
												<td><span class=\"badge rounded-pill badge-light-warning me-1\">ERRO!</span></td>
											</tr>
											";
										}
									?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Bordered table end -->
<?php
}
?>

<script src="mod/maps/leaflet/leaflet.js"></script>
<script>

function vercoord(end) {
	var resultado = 'Latitude e longitude não encontrado!';
	$.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q=' + end, function(data){
		//alert(JSON.stringify(data));
		//var obj = JSON.parse(data);
		res = JSON.stringify(data);
		resultado = 'ID área: ' + data[0].place_id + '<br>';
		resultado += 'ID OSM: ' + data[0].osm_id + '<br>';
		resultado += 'Latitude: ' + data[0].lat + '<br>';
		resultado += 'Longitude: ' + data[0].lon + '<br>';
		resultado += 'Classe: ' + data[0].class + '<br>';
		resultado += 'Tipo: ' + data[0].type + '<br>';
		resultado += 'Completo: ' + data[0].display_name + '<br>';
		resultado += '<a href="https://maps.google.com/?q=' + data[0].lat + ',' + data[0].lon + '" target="_blank">Mapa</a><br>';
		resultado += 'Área: [' + data[0].boundingbox + ']<br>';
		toastr['success'](
			resultado,
			'Localização geográfica',        
			{
				closeButton: true,
				debug: false,
				newestOnTop: false,
				progressBar: false,
				positionClass: "toast-top-right",
				preventDuplicates: false,
				tapToDismiss: true,
				onclick: null,
				showDuration: "300",
				hideDuration: "1000",
				timeOut: "5000",
				extendedTimeOut: "1000",
				showEasing: "swing",
				hideEasing: "linear",
				showMethod: "fadeIn",
				hideMethod: "fadeOut"
			}
		);
	});
};

$(function () {

  SlickLoader.disable();

  const vLatitude = <?php echo $prim_lat;?>;
  const vLongitude = <?php echo $prim_lon;?>;
  const vZoom = <?php echo $cfg_zoom;?>;

  	let camadas = [
		<?php echo $matriz_visitas;?>
		<?php echo $matriz_casas;?>
	];

	<?php
	/*
		if (strlen($matriz_area) > 0){
			echo "let areas = [".$matriz_area."];";
		}
	*/
	?>

	let areas = [
		<?php echo $matriz_area;?>
	];

	/*
	let camadas = [
		[
			'Visitas', 
			23423, 
			'casa2.png',
			'green',
			'#58D68D',
			0.5,
			[
				[-26.699568, -49.175133, '<b>  Soares</b><br>Rua Vale do Selke Pequeno, 830'],
				[-26.708565, -49.158171, '<b>Gabriela Vieira Soares</b><br>Rua Vale do Selke Grande, 1578 - Apto 123 Bloco B'],
				[-26.720402, -49.178667,  '<b>Marina Vieira Soares</b><br>Avenida 21 de Janeiro, 3213 - fundos'],
				[-26.716930, -49.183261, '<b>Arthur Carvalho Soares Neto</b><br>Rua dos Atiradores, 321']
			]
		],
		[
			'Microárea', 
			7899, 
			'casa1.png',
			'red',
			'#f03',
			0.5,
			[
				[-26.771001, -49.180167, '<b>12/12/2002</b><br>Realizada'],
				[-26.760683, -49.160625, '<b>11/11/2022</b><br>Ausente'],
				[-26.802514, -49.158524,  '<b>10/10/2019</b><br>Realizada'],
				[-26.794074, -49.184579, '<b>12/04/2021</b><br>Realizada']
			]
		]
	];
 	*/
	const mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>';
	const mbUrl = 'https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
	const mbAttrOsm = '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>';
	const mbUrlOsm = 'https://tile.openstreetmap.org/{z}/{x}/{y}.png';
	const mbUrlCarto = 'https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png';
	const mbCarto = '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="https://carto.com/attribution">CARTO</a>';

	const positron = L.tileLayer(mbUrlCarto, {attribution: mbCarto});
	const streets = L.tileLayer(mbUrl, {id: 'mapbox/streets-v11', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const satellite = L.tileLayer(mbUrl, {id: 'mapbox/satellite-v9', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const osm = L.tileLayer(mbUrlOsm, {maxZoom: 19, attribution: mbAttrOsm});

	const LeafIcon = L.Icon.extend({
		options: {
			iconSize:     [24, 24],
			iconAnchor:   [22, 94],
			popupAnchor:  [-3, -76]
		}
	});
	const overlays = {};
	let lays = [];
	lays[0] = <?php echo $mapa_abertura;?>;

	let grupo = [];
	let icone = [];
	let itmap = [];
	//let polygon = [];
	var ct_itmap = 0;
	//let pontos_polig = [];
    for(var i = 0; i < camadas.length; i++) {
		grupo[i] = L.layerGroup();
		icone[i] = new LeafIcon({iconUrl: 'mod/maps/img/' + camadas[i][2]});
		overlays[camadas[i][0]] = grupo[i];
		lays[i+1] = grupo[i];
		//pontos_polig = [];
        for(var f = 0; f < camadas[i][6].length; f++) {
			itmap[ct_itmap] = L.marker([camadas[i][6][f][0], camadas[i][6][f][1]], {icon: icone[i]}).bindPopup(camadas[i][6][f][2] + '<br><a href="https://maps.google.com/?q=' + camadas[i][6][f][0] + ',' + camadas[i][6][f][1] + '" target="_blank">Mapa</a><br>' + camadas[i][6][f][0] + ',' + camadas[i][6][f][1]).addTo(grupo[i]);
			ct_itmap++;
			//pontos_polig[f] = [camadas[i][6][f][0], camadas[i][6][f][1]];
        }
		//polygon[i] = L.polygon([pontos_polig],{color: camadas[i][3], fillColor: camadas[i][4], fillOpacity: camadas[i][5]}).bindPopup(camadas[i][0]);
		//overlays['Área: ' + camadas[i][0]] = polygon[i];
    }

	if (typeof areas !== 'undefined') {
		let ipolygon = [];
		var index_layp = lays.length - 1;
		let pontos_polig_areai = [];
		for(var c = 0; c < areas.length; c++) {
			pontos_polig_areai = [];
			for(var f = 0; f < areas[c][7].length; f++) {
				pontos_polig_areai[f] = [areas[c][7][f][0], areas[c][7][f][1]];
			}
			ipolygon[c] = L.polygon([pontos_polig_areai],{color: areas[c][3], fillColor: areas[c][4], fillOpacity: areas[c][5]}).bindPopup(areas[c][0]);
			overlays['Área: ' + areas[c][0]] = ipolygon[c];
			index_layp = index_layp + 1;
			lays[index_layp] = ipolygon[c];
		}
	}



	const baseLayers = {
		'OpenStreetMap': osm,
		'Ruas': streets,
		'Satelite': satellite,
		'Mapa': positron
	};
	const map = L.map('mapv', {
		center: [vLatitude, vLongitude],
		zoom: vZoom,
		layers: lays
	});
	const layerControl = L.control.layers(baseLayers, overlays).addTo(map);

	const popup = L.popup();
	function onMapClick(e) {
    const ta1 = e.latlng.toString().split("(");
    const ta2 = ta1[1].split(",");
    const tLatitude = ta2[0].trim();
    const tLongitude = ta2[1].substring(0,ta2[1].length-1).trim();
		popup
			.setLatLng(e.latlng)
			.setContent('As coordenadas aqui são: ' + tLatitude + ', ' + tLongitude + '<br><a href="https://maps.google.com/?q=' + tLatitude + ',' + tLongitude + '" target="_blank">Mapa</a>')
			.openOn(map);
	}
	map.on('click', onMapClick);

	/*
	$("#btend").click(function() {
		$.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q=' + $("#endereco").val(), function(data){
			//alert(JSON.stringify(data));
			//var obj = JSON.parse(data);
			var resultado = 'ID área: ' + data[0].place_id + '<br>';
			resultado += 'ID OSM: ' + data[0].osm_id + '<br>';
			resultado += 'Latitude: ' + data[0].lat + '<br>';
			resultado += 'Longitude: ' + data[0].lon + '<br>';
			resultado += 'Classe: ' + data[0].class + '<br>';
			resultado += 'Tipo: ' + data[0].type + '<br>';
			resultado += 'Completo: ' + data[0].display_name + '<br>';
			resultado += 'Área: ' + data[0].boundingbox + '<br>';
			$("#resendereco").html(resultado);
		});
	});
	*/

	$('#dtif').daterangepicker({
		startDate: '<?php echo datanas6($dti);?>',
		endDate: '<?php echo datanas6($dtf);?>',
		locale: {
			format: 'DD/MM/YYYY'
		}
	});

	$("#tbtmpbt").click(function() {
		SlickLoader.enable();
		$('.content-body').load('mod/maps/visitas.php?matb=' + $("#matb").find(":selected").val() + '&mostrar=' + $('#mostrar').val() + '&dtif=' + encodeURIComponent($('#dtif').val()));
	});





});




</script>